/*
 * Created on 25-Sep-2006
 *
 */
package ngrave.client.menus;

import java.io.IOException;

import ngrave.client.C2SCommunication;
import ngrave.client.Client;
import ngrave.client.objects.CPlayerObject3D;
import ngrave.server.items.SGrenadeCarried;
import ngrave.server.items.SItemCarried;
import ssmith.opengl.Canvas3D;
import ssmith.opengl.menu.GLMenu;
import ssmith.opengl.menu.GLMenuItem;
import ssmith.opengl.menu.GLMenuLabel;
import ssmith.opengl.menu.GLMenuSelect;
import ssmith.opengl.menu.GLMenuSlider;

public final class mnuGrenadeOptions extends GLMenu {
    
    private CPlayerObject3D trooper;
    private GLMenuSlider timer, distance;
    
    public mnuGrenadeOptions(Canvas3D canv, CPlayerObject3D un) {
        super(canv, Client.GL_FONT, Client.MENU_RED, Client.MENU_GREEN, Client.MENU_BLUE);
        trooper = un;
        
        this.addMenuItem(new GLMenuLabel("Please choose grenade settings"));
        timer = new GLMenuSlider("Timer: ", 1, 40, 5);
        distance = new GLMenuSlider("Distance: ", 1, SItemCarried.THROW_MAX_DIST, 5);
        
        this.addMenuItem(timer);
        this.addMenuItem(distance);
        this.addMenuItem(new GLMenuSelect("Throw"));
        this.addMenuItem(new GLMenuSelect("Cancel"));
    }

    protected void menuItemSelected(GLMenuItem menu_item) {
        if (menu_item.menu_text.equalsIgnoreCase("Throw")) {
            if (trooper.getAPs() >= SGrenadeCarried.PRIME_AND_THROW_COST) {
                int time = new Integer(timer.getCurrentValue()).intValue();
                int dist = new Integer(distance.getCurrentValue()).intValue();
                //if (dist <= SItemCarried.THROW_MAX_DIST) {
                    try {
                        C2SCommunication.SendPrimeAndThrow(trooper, time, dist);
                        //trooper.removeCurrentItem();
                    } catch (IOException ex) {
                        Client.HandleError(ex);
                    }
                //}
            }
        }
        Client.removeMenu();
    }

}
