/*
 * Created on 25-Sep-2006
 *
 */
package ngrave.client.menus;

import java.io.IOException;

import ngrave.client.C2SCommunication;
import ngrave.client.Client;

import ssmith.opengl.Canvas3D;
import ssmith.opengl.menu.GLMenu;
import ssmith.opengl.menu.GLMenuItem;
import ssmith.opengl.menu.GLMenuSelect;
import ssmith.opengl.menu.GLMenuToggle;

public final class mnuGameOptions extends GLMenu {

    private GLMenuToggle textures, music, sound, play_cpu, ghost_mode;
    private static boolean CPU_selected = false;

    public mnuGameOptions(Canvas3D canv) {
        super(canv, Client.GL_FONT, Client.MENU_RED, Client.MENU_GREEN, Client.MENU_BLUE);

        music = new GLMenuToggle("Music:", "On", "Off", Client.isMusicOn());
        sound = new GLMenuToggle("Sound F/X:", "On", "Off", !Client.sfx.mute);
        play_cpu = new GLMenuToggle("Play Against CPU:", "No", "Yes", true);
        if (Client.isInGhostMode()) {
            ghost_mode = new GLMenuToggle("Ghost Mode:", "Yes", "No", true);
        } else {
            ghost_mode = new GLMenuToggle("Ghost Mode:", "No", "Yes", true);
        }
        textures = new GLMenuToggle("Textures:", "On", "Off", Canvas3D.texture_on);

        this.addMenuItem(new GLMenuSelect("Show Keyboard Shortcuts"));
        this.addMenuItem(new GLMenuSelect("List Players"));
        this.addMenuItem(textures);
        this.addMenuItem(sound);
        this.addMenuItem(music);
        if (CPU_selected == false) {
            this.addMenuItem(play_cpu);
        }
        this.addMenuItem(ghost_mode);
        this.addMenuItem(new GLMenuSelect("Save"));
        this.addMenuItem(new GLMenuSelect("Cancel"));
    }

    protected void menuItemSelected(GLMenuItem menu_item) {
        if (menu_item.menu_text.equalsIgnoreCase("Save")) {
            Canvas3D.texture_on = textures.isFirstSelected();
            Client.sfx.mute = !sound.isFirstSelected();
            Client.setMusic(music.isFirstSelected());
            if (play_cpu.getOptionSelected().equalsIgnoreCase("Yes")) {
                try {
                    C2SCommunication.SendPlayAgainstCPU();
                    CPU_selected = true;
                } catch (IOException ex) {
                    Client.HandleError(ex);
                }
            }
            try {
                if (ghost_mode.getOptionSelected().equalsIgnoreCase("Yes")) {// &&  Client.ghost_mode == false) {
                    Client.setGhostMode(true);
                } else if (ghost_mode.getOptionSelected().equalsIgnoreCase("No")) { // &&  Client.ghost_mode) {
                    Client.setGhostMode(false);
                }
            } catch (IOException e) {
                Client.HandleError(e);
            }
            Client.removeMenu();
        } else if (menu_item.menu_text.equalsIgnoreCase("List Players")) {
            Client.setMenu(new mnuListPlayers(this.canvas));
        } else if (menu_item.menu_text.equalsIgnoreCase("Show Keyboard Shortcuts")) {
            Client.setMenu(new mnuShowControls(this.canvas));
        } else {
            Client.removeMenu();
        }
    }

}
