/*
 * Created on 25-Sep-2006
 *
 */
package ngrave.client.menus;

import java.io.IOException;
import java.util.ListIterator;

import ngrave.client.CItemCarried;
import ngrave.client.Client;
import ngrave.client.objects.CPlayerObject3D;
import ssmith.opengl.Canvas3D;
import ssmith.opengl.menu.GLMenu;
import ssmith.opengl.menu.GLMenuItem;
import ssmith.opengl.menu.GLMenuLabel;
import ssmith.opengl.menu.GLMenuSelect;

public final class mnuChangeItem extends GLMenu {

    private CPlayerObject3D unit;

    public mnuChangeItem(Canvas3D canv, CPlayerObject3D un) {
        super(canv, Client.GL_FONT, Client.MENU_RED, Client.MENU_GREEN, Client.MENU_BLUE);
        this.unit = un;

        this.addMenuItem(new GLMenuLabel("Please choose an item to use:"));
        ListIterator enumr = unit.getItemsEnumeration();
        while (enumr.hasNext()) {
            CItemCarried item = (CItemCarried)enumr.next();
            GLMenuItem i = new GLMenuSelect(item.name);
            this.addMenuItem(i);
            if (item == un.getCurrentItem()) {
                this.setCurrentItem(i);
            }
        }
        this.addMenuItem(new GLMenuSelect("Cancel"));
    }

    protected void menuItemSelected(GLMenuItem menu_item) {
    	if (menu_item.menu_text.equalsIgnoreCase("Cancel") == false) {
            ListIterator enumr = unit.getItemsEnumeration();
	        try {
	            while (enumr.hasNext()) {
	                CItemCarried item = (CItemCarried)enumr.next();
	                if (item.name.equalsIgnoreCase(menu_item.menu_text)) {
	                    unit.setCurrentItem(item);
	                    break;
	                }
	            }
	        } catch (IOException ex) {
	            Client.HandleError(ex);
	        }
    	}
        Client.removeMenu();
    }

}
