package ngrave.client;

import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import java.awt.event.ActionListener;
import javax.swing.JTextArea;

import ngrave.server.Server;
import ngrave.server.Statics;

public final class frmClientOptionForm extends JFrame {

	private static final long serialVersionUID = 1L;

	JPanel pnlControls = new JPanel();
	public JComboBox cbServer = new JComboBox();
	JButton cmdGo = new JButton();
	JLabel lblIPAddress = new JLabel();
	JLabel lblTitle = new JLabel();
	GridLayout gridLayout1 = new GridLayout();
	public boolean ok_clicked = false;
	public JCheckBox optTutorial = new JCheckBox();
	public JCheckBox optSuperfast3D = new JCheckBox();
	JTextField txtName = new JTextField();
	JLabel lblName = new JLabel();
	JComboBox cbPort = new JComboBox();
	JLabel lblPort = new JLabel();
	JTextArea lblComment = new JTextArea();

	public frmClientOptionForm() throws Exception {
    	super();
		try {
			jbInit();
			this.cbServer.setEditable(true);
			this.cbPort.setEditable(true);
			this.lblComment.setEditable(false);
			
			this.setTitle(Statics.TITLE);
			this.setSize(297, 398);
			this.setLocation(300, 380);

			lblComment.setText("This game is \"Commentware\".  If you play it, please email a comment to steve16384@users.sourceforge.net.  Any comment will do, from why you dislike the game to how it can be improved.  Thanks in advance!");

			ClientSettings settings = new ClientSettings();
			this.txtName.setText(settings.name);
			if (settings.ip_address.length() > 0) {
				this.cbServer.addItem(settings.ip_address);
			}
			this.cbServer.addItem("ng.game-host.org");

			if (settings.port.length() > 0) {
			this.cbPort.addItem(settings.port);
			}
			this.cbPort.addItem("" + Server.PORT);
			this.cbPort.addItem("" + (Server.PORT+1));

			this.optTutorial.setSelected(settings.tutorial);
			this.optSuperfast3D.setSelected(settings.fast3d);
		}
		catch(Exception ex) {
			Client.HandleError(ex);
		}

	}

	private void jbInit() throws Exception {
		this.getContentPane().setLayout(gridLayout1);
		pnlControls.setLayout(null);
		pnlControls.setOpaque(false);
		pnlControls.setBounds(new Rectangle(670, 500, 320, 280));
		pnlControls.setBounds(new Rectangle(0, 0, 320, 280));
		this.setResizable(false);
		this.setState(Frame.NORMAL);
		this.setTitle(Statics.TITLE);
		cbServer.setToolTipText("Enter the IP address here");
		cbServer.setBounds(new Rectangle(127, 74, 145, 27));
		cmdGo.setBounds(new Rectangle(160, 200, 122, 31));
		cmdGo.setToolTipText("Connect to the selected server");
		cmdGo.setText("Connect");
		cmdGo.addActionListener(new frmClientOptionForm_cmdConnect_actionAdapter(this));
		lblIPAddress.setText("Connect To");
		lblIPAddress.setBounds(new Rectangle(10, 73, 97, 31));
		lblTitle.setFont(new java.awt.Font("Dialog", 1, 18));
		lblTitle.setText(Statics.TITLE + " (v"+Client.VERSION +") Client");
		lblTitle.setBounds(new Rectangle(5, 5, 342, 32));
		optTutorial.setToolTipText("This will provide helpful hints");
		optTutorial.setBorderPainted(true);
		optTutorial.setText("Tutorial Mode");
		optTutorial.setBorderPaintedFlat(false);
		optTutorial.setBounds(new Rectangle(10, 157, 114, 30));
		optSuperfast3D.setToolTipText("Recommended for slower PC\'s");
		optSuperfast3D.setBorderPainted(true);
		optSuperfast3D.setText("Superfast 3D");
		optSuperfast3D.setBorderPaintedFlat(false);
		optSuperfast3D.setBounds(new Rectangle(163, 158, 113, 30)); //cmdLaunchServer.setBackground(Color.green);
		txtName.setText("");
		txtName.setBounds(new Rectangle(127, 39, 148, 24));
		lblName.setText("Player Name");
		lblName.setBounds(new Rectangle(11, 44, 89, 15));
		//txtPort.setText("");
		cbPort.setBounds(new Rectangle(129, 113, 70, 26));
		lblPort.setToolTipText("Enter the port to connect on");
		lblPort.setText("Port");
		lblPort.setBounds(new Rectangle(10, 121, 60, 17));
		lblComment.setLineWrap(true);
		lblComment.setWrapStyleWord(true);
		lblComment.setBounds(new Rectangle(14, 247, 259, 107));
		pnlControls.add(lblTitle, null);
		pnlControls.add(cbServer, null);
		pnlControls.add(lblIPAddress, null);
		pnlControls.add(txtName);
		pnlControls.add(lblName);
		pnlControls.add(optSuperfast3D, null);
		pnlControls.add(cmdGo, null);
		pnlControls.add(optTutorial, null);
		pnlControls.add(cbPort);
		pnlControls.add(lblPort);
		pnlControls.add(lblComment);
		this.add(pnlControls);
	}

    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b) {
        	this.ok_clicked = false;
        }
    }
    
	void cmdConnect_actionPerformed(ActionEvent e) {
		if (txtName.getText().length() > 0) {
			if (cbServer.getSelectedItem().toString().length() > 0) {
				if (cbPort.getSelectedItem().toString().length() > 0) {
					this.ok_clicked = true;
					ClientSettings settings = new ClientSettings();
					settings.saveSettings(this.txtName.getText(), this.cbServer.getSelectedItem().toString(), this.cbPort.getSelectedItem().toString(), this.optTutorial.isSelected(), this.optSuperfast3D.isSelected());
					this.setVisible(false);
				} else {
					JOptionPane.showMessageDialog(this, "Please enter a port.", "No Port", JOptionPane.ERROR_MESSAGE);
				}
			} else {
				JOptionPane.showMessageDialog(this, "Please enter a server.", "No Server", JOptionPane.ERROR_MESSAGE);
			}
		} else {
			JOptionPane.showMessageDialog(this, "Please enter a name.", "No Name", JOptionPane.ERROR_MESSAGE);
		}

	}

}


class frmClientOptionForm_cmdConnect_actionAdapter implements java.awt.event.ActionListener {
	frmClientOptionForm adaptee;

	frmClientOptionForm_cmdConnect_actionAdapter(frmClientOptionForm adaptee) {
		this.adaptee = adaptee;
	}
	public void actionPerformed(ActionEvent e) {
		adaptee.cmdConnect_actionPerformed(e);
	}
}

