package ngrave.client;

import ngrave.server.Statics;

public class Tutorial {

	private int stage=-2; // So we don;t show anything too soon.
	public boolean activated = false;

	public void startTutorial() {
		stage = -1;
	}

	public Tutorial() {
	}

	public void completedStage() {
		this.stage++;
	}

	public String getWords() {
		// Mention action points, and what the HUD means.
		switch (stage) {
		case -1:
			return "Welcome to the " + Statics.TITLE + " tutorial.  Press F1 at any time to move onto the next stage.";
		case 0:
			return "To move your current unit forward, hold down '8' on the keypad.  Make sure Num-Lock is enabled!";
		case 1:
			return "Use the keys 7 and 9 on the keypad to turn your man left and right.  Notice that when you move, your trooper's APs are reduced.";
		case 2:
			return "Use the keys 4 and 6 on the keypad to make your trooper sidestep left and right.";
		case 3:
			return "Click on a unit's stats at the top to select that unit.  The currently selected unit is highlighted.";
		case 4:
			return "Press U to bring up the options for the selected unit.  Use the arrow keys and Return to control the menu.";
		case 5:
			return "If your selected trooper has a gun, pressing 'space' will shoot it.";
		case 6:
			return "Weapons only have a certain amount of ammo, shown on-screen.  Select Reload from Unit Options to reload (if you have enough APs).";
		case 7:
			return "If you want to leave a trooper guarding, but for them not to hold the game up, select Guard from the unit options menu.";
		case 8:
			return "A unit's selector changes to red if they see an enemy.  Select Autofire (Unit Options menu) so the unit shoots automatically when not selected.";
		case 9:
			return "Actions, such as opening doors or deactivating computers, can be performed by selecting Action from the Unit Options menu.";
		case 10:
			return "You can switch to and from an overhead view by clicking on the map in the top-left corner.";
		case 11:
			return "When in overhead view mode, the keys + and - allow you to zoom in and out.  You can still control units in this view.";
		case 12:
			return "You can toggle the level of accuracy of your unit in Unit Options.  More accurate shots costs more APs.";
		case 13:
			return "Press G at any time for the Game Options menu, which will also show you keyboard shortcuts.";
		case 14:
			return "If there is no computer controlled side and you wish to play against the computer, select Play CPU from the Game Options.";
		case 15:
			return "This game is persistent.  This means that you can disconnect, and reconnect later to pick up from the same point.";
		case 16:
			return "You have finished the tutorial.  Now find the enemy and destroy them!";
		default:
			return "";
		}
	}

}
