/*
 * Created on Oct 10, 2005
 *
 */
package ngrave.client;

import ssmith.opengl.Textures;
import net.java.games.jogl.GL;
import ngrave.loadImage;

/**
 * @author Stephen Smith
 *
 */
public class TexLoader extends Textures {

	  // Texture codes
	  public static final int OUTER_WALL=0, INNER_FLOOR=1, OUTER_FLOOR=2, DOOR=3, PLANET=4;
	  public static final int PLASMA1=5, STARFIELD=6, SHIP=7, CEILING=8, ATTACKERS_COMPUTER=9;
	  public static final int DEFENDERS_COMPUTER=10, TROOPER=11, LOCKED_DOOR=12, EXIT=13;
	  public static final int ALIEN_SKIN=14, PLASMA2=15, TREE_TRUNK=16, TREE_LEAVES=17;
	  public static final int BARREL=18, SMOKE=19, CRATE=20, FURNITURE=21, WATER=22;
	  public static final int POSTER1=23, POSTER2=24, POSTER3=25, ROAD=26;
	  public static final int POSTER4=31, STAR=32;
	  private static final int MAX_TEXTURES=33;

	  // List nos
	  //public static final int PERSON=1;

	  /**
	 *
	 */
	public TexLoader() {
		super(Client.TEXTURE_DIR, MAX_TEXTURES);
	}

	/* (non-Javadoc)
	 * @see ssmith.opengl.Textures#loadTextures()
	 */
	public void loadTextures() {
		super.loadTexture(OUTER_WALL, Client.mission.getOuterWallTexture());
		super.loadTexture(INNER_FLOOR, Client.mission.getInnerFloorTexture());
		super.loadTexture(OUTER_FLOOR, Client.mission.getOuterFloorTexture());
		super.loadTexture(DOOR, Client.mission.getDoorTexture());
		super.loadTexture(PLANET, "planet.png");
		super.loadTexture(PLASMA1, "cells2.png");
		super.loadTexture(STARFIELD, Client.mission.getStarfieldTexture());
		super.loadTexture(SHIP, "spaceship_hull.png");
		super.loadTexture(CEILING, Client.mission.getCeilingTexture());
		super.loadTexture(ATTACKERS_COMPUTER, "cpu1.png");
		super.loadTexture(DEFENDERS_COMPUTER, "cpu2.png");
		super.loadTexture(TROOPER, "trooper.png");
		super.loadTexture(LOCKED_DOOR, Client.mission.getLockedDoorTexture());
		super.loadTexture(EXIT, Client.mission.getExitTexture());
		super.loadTexture(ALIEN_SKIN, "alien skin.png");
		super.loadTexture(PLASMA2, "cells3.png");
		super.loadTexture(TREE_TRUNK, "treetrunk.png");
		super.loadTexture(TREE_LEAVES, "tree01.png");
		super.loadTexture(BARREL, "depot.png");
		super.loadTexture(SMOKE, "smoke.png");
		super.loadTexture(CRATE, "crate.png");
		super.loadTexture(FURNITURE, "trooper.png");
		super.loadTexture(WATER, "water14t.png");
		super.loadTexture(POSTER1, Client.mission.getPictureTexture(POSTER1));
		super.loadTexture(POSTER2, Client.mission.getPictureTexture(POSTER2));
		super.loadTexture(POSTER3, Client.mission.getPictureTexture(POSTER3));
		super.loadTexture(POSTER4, Client.mission.getPictureTexture(POSTER4));
                super.loadTexture(ROAD, Client.mission.getRoadTexture());
                //super.loadTexture(STAR, "star.png");
                loadImage  TextureImage = loadBMP("./data/textures/star.bmp");    // Create Storage Space For The Texture
                gl.glBindTexture(GL.GL_TEXTURE_2D, textures[STAR]);
                gl.glTexParameteri(GL.GL_TEXTURE_2D, GL.GL_TEXTURE_MAG_FILTER, GL.GL_LINEAR);
                gl.glTexParameteri(GL.GL_TEXTURE_2D, GL.GL_TEXTURE_MIN_FILTER, GL.GL_LINEAR);
                gl.glTexImage2D(GL.GL_TEXTURE_2D, 0, 3, TextureImage.width, TextureImage.height, 0,GL.GL_RGB, GL.GL_UNSIGNED_BYTE, TextureImage.data);
	}

        private loadImage loadBMP(String filename){

          loadImage  loader = new loadImage();
          loader.generateTextureInfo(filename, false);
          return loader;
        }


}
