package ngrave.client;

import ssmith.audio.MP3Player;

public class MusicPlayer {

    private boolean music_on = true;
    private MP3Player mp3;
    private String filename;

    public MusicPlayer(boolean mute) {
        this.music_on = !mute;
    }

    public void playTune(String fname) {
        if (mp3 != null) {
            mp3.stopNow();
        }
        this.filename = fname;
        if (this.music_on) {
            mp3 = new MP3Player(fname);
        }
    }

    public void playCurrentTune() {
        this.playTune(filename);
    }

    public boolean isMusicOn() {
        return this.music_on;
    }

    public void setMusicOn(boolean b) {
        if (b != this.music_on) {
            this.music_on = b;
            this.playCurrentTune();
        }
        this.music_on = b;
    }

}
