package ngrave.client;

import java.util.*;
import net.java.games.jogl.GL;
import ngrave.server.Statics;

public final class MessageLog {

	private static final int MAX_MESSAGES=10;

	private ArrayList messages = new ArrayList();

	public MessageLog() {
	}

	public void draw(GL gl) {
		int size = Math.min(MAX_MESSAGES, messages.size());
		int x = 20;
		int y = Client.canvas.getHeight() - (size * 20) - 20;
		for(int m=0 ; m < size  ; m++) {
			Message msg = getMessage(m);
			if (msg != null) {
				switch(msg.priority) {
				case 0:
					gl.glColor3f(0f, 1f, 0f);
					break;
				case 1:
					gl.glColor3f(1f, 1f, 0f);
					break;
				default:
					gl.glColor3f(.7f, 0f, 0f);
				break;
				}
				Client.canvas.writeString(gl, x, y, Client.GL_FONT, msg.getString());
				y += 17;
			}
		}
	}

	public void addMessage(String msg, int pri) {
		//System.out.println(msg);
		messages.add(new Message(msg, pri));
		if (messages.size() > MAX_MESSAGES) {
			messages.remove(0);
		}
		Client.sfx.playSound(Statics.SOUND_DIR + "msg.wav");
	}

	public Message getMessage(int no) {
		try {
			return (Message) messages.get(no);
		} catch (Exception ex) {
			ex.printStackTrace();
		}
		return null;
	}

	private static class Message {

		private String msg;
		public int priority;
		private int length_shown = 0;

		public Message(String m, int pri) {
			msg = m;
			this.priority = pri;
		}

		public String getString() {
			if (this.length_shown < msg.length()) {
				this.length_shown += 2;
				if (this.length_shown > msg.length()) {
					this.length_shown = msg.length();
				}
			}
			return msg.substring(0, this.length_shown);
		}

	}

}
