package ngrave.client;

import java.awt.*;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;

import javax.swing.*;

import ngrave.client.objects.CMapSquare;
import ngrave.client.objects.CPlayerObject3D;
import ngrave.server.SMapSquare;

public final class DisplayPanel extends JPanel implements MouseListener {

	private static final long serialVersionUID = 1L;

	private static final int PANEL_HEIGHT = 150;
	public static final int MAP_X=10, MAP_Y=10, MAP_MAX_WIDTH=160;
	private static Font FONT = new Font("Impact", Font.PLAIN, 12);
	private static final Color ddgreen = Color.GREEN.darker().darker();

	private Image map;
	private Component c;
	private boolean map_image_created = false;
	private int sq_size;

	public DisplayPanel(Component c, int width) {
		this.addMouseListener(this);
		this.c = c;
		this.setFocusable(false);
		this.setPreferredSize(new Dimension(width, PANEL_HEIGHT));
	}

	public void redrawMapImage() {
		map_image_created = false;// Mark it as needing recreating
	}

	public void paint(Graphics g) {
		g.setColor(Color.black);
		g.fillRect(0, 0, this.getWidth(), this.getHeight());
		// Draw map
		if (Client.map != null) {
			if (map_image_created == false) {
				if (Client.map.wholeMapReceived()) {
					sq_size = this.getHeight() / Client.getMapSize();
					map = c.createImage(Client.getMapSize() * sq_size, Client.getMapSize()
							* sq_size);
					createMapImage();
				}
			} else {
				g.drawImage(map, MAP_X, MAP_Y, c);
			}
		} else {
		}

		g.setFont(FONT);
		int x = MAP_MAX_WIDTH;
		int y = 20;
		// Loop through troopers and draw details
		if (Client.units_on_my_side != null) {
			int size = Client.units_on_my_side.size();
			for (int p = 0; p < size; p++) {
				try {
					CPlayerObject3D player_obj = (CPlayerObject3D) Client.units_on_my_side.get(p);
					// Draw them on the map
					g.setColor(Color.white);
					g.fillRect(MAP_X + ((int) player_obj.getX() * sq_size), MAP_Y
							+ ((int) player_obj.getZ() * sq_size), sq_size+1, sq_size+1);

					//  Draw their details
					g.translate(x, y);
					player_obj.draw(g);
					g.translate(-x, -y);
					x += CPlayerObject3D.TROOPER_SELECTOR_WIDTH;
				} catch (IndexOutOfBoundsException e) {
					Client.HandleError(e);
				}
			}
		}

		// Draw rotation
		if (Client.camera.getViewer() != null) {
			g.setColor(Color.yellow);
			int x_pos = MAP_X + ((int) Client.camera.getViewer().getX() * sq_size);
			int y_pos = MAP_Y + ((int) Client.camera.getViewer().getZ() * sq_size);
			int radius = 28;

			// Draw main angle
			x = (int) (Math.cos(Math
					.toRadians(270 - Client.camera.getViewer().y_angle)) * radius);
			y = (int) (Math.sin(Math
					.toRadians(270 - Client.camera.getViewer().y_angle)) * radius);
			g.drawLine(x_pos, y_pos, x_pos + x, y_pos + y);
		}

	}

	public void createMapImage() {
		if (map != null) {
			Graphics g = map.getGraphics();
			if (g != null) {
				// Load map details.
				for (int y = 0; y < Client.getMapSize(); y++) {
					for (int x = 0; x < Client.getMapSize(); x++) {
						CMapSquare sq = Client.map.getMapSquare(x, y);
						if (sq != null) {
							if (sq.type == SMapSquare.CLOSED_DOOR ||
									sq.type == SMapSquare.OPEN_DOOR) {
								//g.setColor(Color.pink);
								g.setColor(ddgreen);
							} else if (sq.type == SMapSquare.ATTACKER_COMPUTER ||
									sq.type == SMapSquare.DEFENDER_COMPUTER) {
								g.setColor(Color.red);
							} else if (sq.blocksMovement() == false) {
								g.setColor(Color.black);
							} else {
								g.setColor(Color.green);
							}
							g.drawRect(x * sq_size, y * sq_size, 1, 1);
						}
					}
				}
				map_image_created = true;
			}
		}
	}

	public void mouseClicked(MouseEvent me) {
		//System.out.println("Mouse clicked at " + me.getX() + ", " + me.getY());
		if (me.getX() <= MAP_MAX_WIDTH) {
			Client.camera.toggleView();
		} else {
			int x = (me.getX() - MAP_MAX_WIDTH) / CPlayerObject3D.TROOPER_SELECTOR_WIDTH;
			if (x < Client.units_on_my_side.size()) {
				try {
					C2SCommunication.SendChangedTrooper((CPlayerObject3D)Client.units_on_my_side.get(x));
				} catch (IOException e) {
					Client.HandleError(e);
				}
			}
		}
	}

	public void mouseEntered(MouseEvent arg0) {

	}

	public void mouseExited(MouseEvent arg0) {

	}

	public void mousePressed(MouseEvent arg0) {

	}

	public void mouseReleased(MouseEvent arg0) {

	}

}
