package ngrave.client;

import java.io.IOException;
import ssmith.io.*;
import ssmith.util.CSVString;

public class ClientSettings {

	private static final String FILENAME = "client_settings.dat";
	private static final String NAME = "name";
	private static final String IP = "ip";
	private static final String PORT = "port";
	private static final String TUTORIAL = "tutorial";
	private static final String FAST3D = "fast3d";

	public String name = "", ip_address = "", port="";
	public boolean tutorial = true, fast3d = false;

	public ClientSettings() {
		super();
		TextFile tf = new TextFile();
		try {
			tf.openFile(FILENAME, TextFile.READ);
			while (tf.isEOF() == false) {
				CSVString line = new CSVString(tf.readLine(), "=");
				if (line.getFirstSection().equalsIgnoreCase(NAME)) {
					name = line.getSection(1);
				} else if (line.getFirstSection().equalsIgnoreCase(
						IP)) {
					ip_address = line.getSection(1);
				} else if (line.getFirstSection().equalsIgnoreCase(
						PORT)) {
					port = line.getSection(1);
				} else if (line.getFirstSection().equalsIgnoreCase(
						TUTORIAL)) {
					tutorial = line.getSection(1).equalsIgnoreCase(
							"Y");
				} else if (line.getFirstSection().equalsIgnoreCase(
						FAST3D)) {
					fast3d = line.getSection(1).equalsIgnoreCase(
							"Y");
				}
			}
			tf.close();
		} catch (IOException e) {
			// Nothing
		}
	}

	public void saveSettings(String players_name, String ip, String port, boolean tutor, boolean f3d) {
		TextFile tf = new TextFile();
		try {
			tf.openFile(FILENAME, TextFile.WRITE);
			tf.writeLine(NAME + "=" + players_name);
			tf.writeLine(IP + "=" + ip);
			tf.writeLine(PORT + "=" + port);
			if (tutor) {
				tf.writeLine(TUTORIAL + "=Y");
			} else {
				tf.writeLine(TUTORIAL + "=N");
			}
			if (f3d) {
				tf.writeLine(FAST3D + "=Y");
			} else {
				tf.writeLine(FAST3D + "=N");
			}
			tf.close();
		} catch (IOException e) {
			// Nothing
		}
	}

}
