/*
 Laser Tactics - Copyright (C)2008 Stephen Carlyle-Smith <steve16384@users.sourceforge.net>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package ngrave.client;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import ssmith.audio.SoundCache;
import ssmith.awt.EZFrame;
import ssmith.game.CollisionMatrix2D;
import ssmith.lang.Functions;
import ssmith.net.NetworkClient2;
import ssmith.opengl.Canvas3D;
import ssmith.opengl.IGameLoop;
import ssmith.opengl.IManualDraw;
import ssmith.opengl.menu.GLMenu;
import ssmith.util.Interval;
import ssmith.util.TimeFunctions;
import net.java.games.jogl.*;
import net.java.games.jogl.util.GLUT;
import ngrave.client.menus.mnuChangeItem;
import ngrave.client.menus.mnuConfirmExit;
import ngrave.client.menus.mnuGameOptions;
import ngrave.client.menus.mnuGrenadeOptions;
import ngrave.client.menus.mnuSelectSide;
import ngrave.client.menus.mnuSendMessage;
import ngrave.client.menus.mnuUnitOptions;
import ngrave.client.objects.CBullet;
import ngrave.client.objects.CObject;
import ngrave.client.objects.CPlayerObject3D;
import ngrave.missions.Mission;
import ngrave.server.S2CCommunication;
import ngrave.server.Server;
import ngrave.server.Statics;
import ngrave.server.items.SItemCarried;

import java.util.Date;

/**
 * BEFORE INSTALL!:- Fill in changelog in readme.txt Turn demo OFF (and others)
 * Increase version no Remove crap from .zip
 * file. - bak, jbx, xls.  Create by copying files to new directory!
 *
 */
public final class Client extends EZFrame implements IManualDraw, IGameLoop {

	private static final long serialVersionUID = 1L;

	// Options
	public static final float VERSION = 1.3f;

	public static final boolean DEBUG = false;
	public static final boolean QUICKSTART = false;
	public static final boolean SMALL_WINDOW = false, HALF_WINDOW = false;
	public static final boolean SHOW_OBJ_CREATION = false, SHOW_COMMS = false;
	public static final boolean SHOW_KEY_PRESSES = false, SHOW_AI = false;
	public static final boolean DEFAULT_AUTOFIRE = false;
	public static final boolean SHOW_BULLETTRAILS = true;

	private static final String EXCEPTION_FILE = "Client_Exception.txt";
	public static final String DATA_DIR = "./data/";
	public static final String MISSION_DIR = "./data/missions/";
	public static final String TEXTURE_DIR = "./data/textures/";
	public static final float MAX_VIEW_DIST = 40f;
	public static int GL_FONT = GLUT.BITMAP_HELVETICA_12;
	public static final int TURN_SPEED = 1;
	public static final float TURN_COST = 0.022f; // Cost to turn by 1 degree.
	public static final float MOVE_SPEED = 0.06f;
	private static final int LOOP_DELAY = 25;
	public static final byte ATTACKER = 0, DEFENDER = 1;
	public static final float GREY = 0.5f, GREY_D = 0.4f, GREY_DAMAGED=0.3f;
	public static final float MENU_RED = 0f, MENU_GREEN = 1f, MENU_BLUE = 0f;

	// Keys
	public static final int KEY_FWD = 104, KEY_BACK = 98;
	public static final int KEY_TURN_LEFT = 103, KEY_TURN_RIGHT = 105;
	public static final int KEY_SLIDE_LEFT = 100, KEY_SLIDE_RIGHT = 102;
	public static final int KEY_SHOOT = 32, KEY_RELOAD = 82, KEY_ACTION = 79;
	public static final int KEY_AUTOFIRE = 65, KEY_GUARD = 83, KEY_WAIT = 87;
	public static final int KEY_CHANGE_ITEM = 67;
	public static final int KEY_NEXT = 78, KEY_PREV = 80, KEY_MAP = 77;
	public static final int KEY_ZOOM_IN = 107, KEY_ZOOM_OUT = 109;
	public static final int KEY_PAN_FWD = 106, KEY_PAN_BACK = 111;
	public static final int KEY_SHOT_TYPE = 88;

	// Realtime delay values
	public static final long SHOOT_DELAY = 2000;
	public static final long RELOAD_DELAY = 4000;
	public static final long ACTION_DELAY = 500;

	public static Canvas3D canvas;
	private static DisplayPanel hud_panel;
	public static Camera camera;
	public static final TexLoader texloader = new TexLoader();
	public static SoundCache sfx = new SoundCache(Statics.MUTE);
	private Interval breath_interval = new Interval(1000);
	private Interval ambience_interval = new Interval(10000);

	public static NetworkClient2 netClient = null;
	public static CMapData map;
	public static CPlayerObject3D current_unit;
	public static CObject objects[];
	public static ArrayList client_processed_objects = new ArrayList();
	public static volatile ArrayList units_on_my_side = new ArrayList();
	private boolean keys[] = new boolean[255];
	public static final MessageLog log = new MessageLog();
	private static final Tutorial tutor = new Tutorial();
	public static Mission mission;
	private static int elapsed_time;
	public static String str_view_mode_text = "";
	private Interval check_seen_objects_interval = new Interval(1000);
	public static boolean superfast3d;
	private static GLMenu current_menu; // Are we showing a menu?
	public static CPlayers players = new CPlayers();
	private Interval check_ping_interval = new Interval(60000);
	public static PingTest ping_test = new PingTest();
	private static CSideData side_data;
	private static boolean ghost_mode = false;
	private static boolean quit_now = false;
	public long connected_time;
	public static CollisionMatrix2D coll_matrix; // todo - make private
	private static MusicPlayer mplayer = new MusicPlayer(Statics.MUTE);
	private int curr_turn_speed = TURN_SPEED;
	private static String winner_text = "";
	private boolean side_sent = false;

	//*******************************

	public static void main(String[] args) {
		if (DEBUG) {
			System.out.println("Length: " + args.length);
			for (int i=0 ; i<args.length ; i++) {
				System.out.println(i + ": " + args[i]);
			}
		}
		new Client();

	}

	public Client() {
		super(800, 600, Statics.TITLE);

		if (DEBUG) {
			System.out.println("Warning - DEBUG mode on");
		}
		if (QUICKSTART) {
			System.out.println("Warning - QUICKSTART mode on");
		}
		if (SMALL_WINDOW) {
			System.out.println("Warning - SMALL_WINDOW mode on");
		}

		if (Statics.MUTE) {
			System.out.println("Warning - MUTE on");
		}

		try {
			mplayer.playTune("./data/music/Beat Yo.mp3");
			jbInit();

			frmClientOptionForm options = new frmClientOptionForm();
			if (!QUICKSTART) {
				options.setVisible(true);
				int try_again = JOptionPane.YES_OPTION;
				while (try_again == JOptionPane.YES_OPTION) {
					try {
						options.setVisible(true);
						while (options.isVisible()) {
							Functions.delay(1000);
						}
						if (options.ok_clicked == false) {
							System.out.println("Game abandoned.");
							System.exit(0);
						}
						if (options.cbServer.getItemCount() == 0) {
							options.cbServer.addItem("127.0.0.1");
						}
						String ip = options.cbServer.getSelectedItem().toString();
						log.addMessage("Connecting to " + ip + "...", 0);
						netClient = new ssmith.net.NetworkClient2(new Integer(options.cbPort.getSelectedItem().toString()).intValue());
						netClient.connect(ip);
						try_again = JOptionPane.NO_OPTION;
					} catch (UnknownHostException e) {
						try_again = JOptionPane.showConfirmDialog(this, "Error: "
								+ e.getMessage() + "\nThe " + Statics.TITLE + " server does not seem to be running.  Do you wish to try again?");
					} catch (IOException e) {
						try_again = JOptionPane.showConfirmDialog(this, "Error: "
								+ e.getMessage() + "\nPlease ensure you are not blocked by a firewall.\nDo you wish to try again?",
								"Error connecting", JOptionPane.YES_NO_OPTION);
					}
				}
			} else {
				netClient = new ssmith.net.NetworkClient2(Server.PORT);
				netClient.connect("127.0.0.1");
			}

			if (netClient.connected) {
				log.addMessage("Connected.", 0);
				connected_time = System.currentTimeMillis();
				C2SCommunication.WriteString(netClient.getOutput(), Statics.CONNECTION_STRING);
				C2SCommunication.SendPing();

				tutor.activated = options.optTutorial.isSelected();
				Client.superfast3d = options.optSuperfast3D.isSelected();
				players.addPlayer(-1, options.txtName.getText(), (byte)-1); // Must be BEFORE we sendPlayersData() cos that's where it gets it's info from
				C2SCommunication.SendPlayersData(); // Must be first
				log.addMessage("Welcome to " + Statics.TITLE + ", " + players.getThisPlayer().getName() + ".  Waiting for response...", 0);

				camera = new Camera();
				canvas = new Canvas3D(MAX_VIEW_DIST, camera, this, this, null, LOOP_DELAY); // Need this to accept the objects that get added to the canvas

				this.setupScreen();
			} else {
				System.out.println("Not connected.");
				System.exit(0);
			}
		} catch (Exception e) {
			HandleError(e);
			System.exit(1);
		}
	}

	private void setupScreen() {
		Canvas3D.texture_on = !superfast3d;
		canvas.setTextures(texloader);
		this.getContentPane().setLayout(new BorderLayout());
		hud_panel = new DisplayPanel(this, this.getWidth());
		this.getContentPane().add("North", hud_panel);
		this.getContentPane().add("Center", canvas.glcanvas);
		Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
		if (SMALL_WINDOW) {
			this.setSize(200, 200);
			this.setLocation(400, 800);
		} else {
			if (HALF_WINDOW) {
				this.setSize(dim.width/2, dim.height);
			} else {
				this.setSize(dim.width, dim.height);
			}
		}
		this.setVisible(true);

		// Wait for GL to warm up) {
		canvas.startAnim();
		while (Canvas3D.is_drawing == false) {
			Functions.delay(100);
		}

		mplayer.playTune("./data/music/Beat 16.mp3");

		Client.sfx.playSound(Statics.SOUND_DIR + "comet1.wav");
	}

	public void glGameLoop() {
		if (quit_now) {
			QuitNow();
		}
		try {
			if (side_sent == false) {
				if (Client.players.getThisPlayer().side >= 0) {
					C2SCommunication.SendPlayersSide();
					if (Client.tutor.activated) {
						Client.tutor.startTutorial();
					}
					start();
					side_sent = true;
				}
			}
			//System.out.println("Moving camera");
			camera.process();

			//System.out.println("Processing keys");
			this.processKeys();

			if (netClient.getInput().available() > 0) {
				//System.out.println("Bytes waiting: "+client.getInput().available());
				decodeData();
				//System.out.println("Finished.");
			}

			// Process scenery
			if (Client.client_processed_objects != null) {
				//System.out.println("processing scenery");
				CObject obj;
				IClientControlled scenery;
				int size = Client.client_processed_objects.size();
				try {
					for (int s = 0; s < size; s++) {
						obj = (CObject) Client.client_processed_objects.get(s);
						if (obj instanceof IClientControlled) {
							scenery = (IClientControlled) obj;
							scenery.process();
						}
					}
				} catch (IndexOutOfBoundsException ex) {
					// Probably cos somethings been removed
				}
			}

			// Check what objects should be drawn
			if (Client.objects != null) {
				if (check_seen_objects_interval.hitInterval()) {
					CObject obj;
					for (int s = 0; s < Client.objects.length; s++) {
						obj = (CObject) Client.objects[s];
						if (obj != null) {
							obj.checkIfCanBeSeen();
						}
					}
				}
			}

			// Breath sound?
			if (current_unit != null) {
				if (camera.isLockedToTrooper()) {
					if (breath_interval.hitInterval()) {
						/*if (camera.getViewer().getOwner() == Client.ATTACKER) {
                                sfx.playSound(SOUND_DIR + "heartbeat.wav");
                            } else {*/
						sfx.playSound(Statics.SOUND_DIR + "breath.wav");
						//}
					}
					breath_interval.setInterval(current_unit.getHealth() * 150);
				}
			}
			if (current_unit != null) {
				//if (current_unit.getMapSquare().
				if (ambience_interval.hitInterval()) {
					if (Functions.rnd(1, 5) == 1) {
						sfx.playSound(Statics.SOUND_DIR + "space_ambience.wav");
					}
				}
			}
			if (check_ping_interval.hitInterval()) {
				C2SCommunication.SendPing();
			}

		} catch (IOException ex) {
			log.addMessage("Error: " + ex.getMessage(), (byte)2);
			HandleError(ex);
			//System.exit(1); No, as we may want to read a message
		} catch (Exception ex) {
			log.addMessage("Error: " + ex.getMessage(), (byte)2);
			HandleError(ex);
		}
	}

	public void run() {
		while (this.isVisible()) {
			hud_panel.repaint();
			Functions.delay(250);
		}
	}

	public static void setMusic(boolean on) {
		mplayer.setMusicOn(on);
		/*            if (mp3 != null) {
                if (on != music_on) {
                    if (on) {
                        mp3 = new MP3Player("./data/beat 16.mp3");
                        mp3.start();
                    } else {
                        mp3.stopNow();
                    }
                }
                music_on = on;
            }*/
	}

	public static boolean isMusicOn() {
		return mplayer.isMusicOn();
	}

	/**
	 * NO COMMS SHOULD BE FIRED FROM THIS FUNCTION!!
	 */
	public void keyPressed(KeyEvent e) {
		//System.out.println("e" + e.getKeyCode());
		try {
			if (Client.tutor.activated) {
				if (e.getKeyCode() == KeyEvent.VK_F1) {
					Client.tutor.completedStage();
				}
			}
			if (current_menu != null) {
				if (e.getKeyCode() == KeyEvent.VK_DOWN) {
					current_menu.nextItem();
				} else if (e.getKeyCode() == KeyEvent.VK_UP) {
					current_menu.prevItem();
				} else if (e.getKeyCode() == KeyEvent.VK_ENTER) {
					current_menu.selectCurrentItem();
				} else if (e.getKeyCode() == KeyEvent.VK_ESCAPE) {
					Client.removeMenu();
				} else {
					current_menu.receivedChar(e);
				}
				return;
			}

			if (e.getKeyCode() == KeyEvent.VK_G) {
				current_menu = new mnuGameOptions(canvas);
			} else if (e.getKeyCode() == KeyEvent.VK_ESCAPE) {
				current_menu = new mnuConfirmExit(canvas);
			} else if (e.getKeyCode() == KeyEvent.VK_T) {
				current_menu = new mnuSendMessage(canvas);
			} else if (e.getKeyCode() == KEY_MAP) {
				camera.toggleView();
			} else if (e.getKeyCode() == KEY_SHOT_TYPE) {
				if (Client.current_unit != null) {
					Client.current_unit.toggleShotType();
				}
			} else if (e.getKeyCode() == KEY_NEXT) {
				if (ghost_mode == false) {
					C2SCommunication.SendSelectNextUnit();
				} else {
					selectNextGhostUnit();
					Client.str_view_mode_text = "GHOST MODE";
				}
			} else if (e.getKeyCode() == KEY_PREV) {
				if (ghost_mode == false) {
					C2SCommunication.SendSelectPrevUnit();
				} else {
					this.selectPrevGhostUnit();
					Client.str_view_mode_text = "GHOST MODE";
				}
			}

			if (current_unit != null) {
				if (current_unit.isDestroyed()) {
					// Cant get any further if current trooper is dead!
					return;
				}
			}
			if (Statics.BULLETS_FREEZE_GAME && CBullet.IsBullets()) {
				// Can't do anything while bullets are firing!
				return;
			}

			if (e.getKeyCode() == KEY_WAIT) {
				C2SCommunication.SendWait(current_unit);
			} else if (e.getKeyCode() == KEY_CHANGE_ITEM) {
				showChangeItemSelector();
			} else if (e.getKeyCode() == KeyEvent.VK_U) {
				showUnitOptions();
			} else if (e.getKeyCode() == KEY_AUTOFIRE) {
				if (current_unit != null) {
					current_unit.toggleAutofire();
				}
			} else if (e.getKeyCode() == KEY_GUARD) {
				if (current_unit != null) {
					current_unit.toggleGuard();
				}
			} else if (e.getKeyCode() == KEY_SHOOT) {
				if (current_unit != null) {
					if (current_unit.getCurrentItem() != null) {
						// Is it a grenade?
						if (current_unit.getCurrentItem().type ==
							SItemCarried.GRENADE) {
							current_menu = new mnuGrenadeOptions(canvas,
									current_unit);
						} else {
							C2SCommunication.SendUseItem(
									current_unit);
						}
					}
				}
			} else if (e.getKeyCode() == KEY_RELOAD) {
				Reload();
			} else if (e.getKeyCode() == KEY_ACTION) {
				if (current_unit != null) {
					C2SCommunication.SendAction(current_unit);
				}
			} else if (e.getKeyCode() <= Byte.MAX_VALUE) {
				if (keys[e.getKeyCode()] == false) { // Have we changed?
					if (Client.SHOW_KEY_PRESSES) {
						System.out.println(
								"Client: Key pressed sent to server: " +
								e.getKeyCode());
					}
					keys[e.getKeyCode()] = true;
					// Send it to the server
					C2SCommunication.SendKeyPressed((byte)
							e.getKeyCode());
				}
			}
		} catch (Exception ex) {
			HandleError(ex);
		}
	}

	public static void Reload() {
		try {
			Client.sfx.playSound(Statics.SOUND_DIR + "reload.wav");
			C2SCommunication.SendReload(current_unit);
		} catch (IOException ex) {
			Client.HandleError(ex);
		}
	}

	private static void selectNextGhostUnit() {
		int start = 0;
		if (camera.getViewer() != null) {
			try {
				start = Client.units_on_my_side.indexOf(camera.getViewer());
			} catch (Exception e) {
				Client.HandleError(e);
			}
		}
		for (int u=start+1 ; u < units_on_my_side.size() ; u++) {
			CPlayerObject3D unit = (CPlayerObject3D)units_on_my_side.get(u);
			camera.showFromTrooper(unit);
			current_unit = unit;
			break;
		}

	}

	private void selectPrevGhostUnit() {
		int start = Client.units_on_my_side.size()-1;
		if (camera.getViewer() != null) {
			try {
				start = Client.units_on_my_side.indexOf(camera.getViewer());
			} catch (Exception e) {
				Client.HandleError(e);
			}
		}
		for (int u=start-1 ; u >= 0 ; u--) {
			CPlayerObject3D unit = (CPlayerObject3D)units_on_my_side.get(u);
			camera.showFromTrooper(unit);
			current_unit = unit;
			break;
		}

	}

	/**
	 * NO COMMS SHOULD BE FIRED FROM THIS FUNCTION AS ITS IN A SEPERATE THREAD!!
	 */
	public void keyReleased(KeyEvent e) {
		try {
			/*
                if (e.getKeyCode() == KEY_TURN_LEFT || e.getKeyCode() == KeyEvent.VK_LEFT) {
                    keys[e.getKeyCode()] = false;
                    if (Client.current_unit != null) { // Send angle again to keep server up to date
                        C2SCommunication.SendAngle(this.current_unit);
                    }
                } else if (e.getKeyCode() == KEY_TURN_RIGHT || e.getKeyCode() == KeyEvent.VK_RIGHT) {
                    keys[e.getKeyCode()] = false;
                    if (Client.current_unit != null) { // Send angle again to keep server up to date
                        C2SCommunication.SendAngle(this.current_unit);
                    }
                } else*/ if (e.getKeyCode() <= Byte.MAX_VALUE) {
                	if (keys[e.getKeyCode()] == true) { // Have we changed?
                		keys[e.getKeyCode()] = false;
                		if (Client.SHOW_KEY_PRESSES) {
                			System.out.println(
                					"Client: Key released sent to server: " +
                					e.getKeyCode());
                		}
                		C2SCommunication.SendKeyReleased((byte) e.getKeyCode());
                	}
                }
		} catch (Exception ex) {
			HandleError(ex);
		}
	}

	private void processKeys() throws IOException {
		if (Statics.BULLETS_FREEZE_GAME == false || CBullet.IsBullets() == false) {
			// Can't do anything while bullets are firing!
			if (Client.current_unit != null && ghost_mode == false) {
				if (keys[KEY_TURN_LEFT] || keys[KeyEvent.VK_LEFT]) {
					Client.current_unit.turnIfEnoughAPs(curr_turn_speed);
					curr_turn_speed += 1;
				} else if (keys[KEY_TURN_RIGHT] || keys[KeyEvent.VK_RIGHT]) {
					Client.current_unit.turnIfEnoughAPs( -curr_turn_speed);
					curr_turn_speed += 1;
				} else {
					curr_turn_speed = Client.TURN_SPEED;

				}

				if (keys[KEY_FWD] || keys[KeyEvent.VK_UP]) {
					Client.current_unit.moveForwardsIfEnoughAPs();
				} else if (keys[KEY_BACK] || keys[KeyEvent.VK_DOWN]) {
					Client.current_unit.moveBackwardsIfEnoughAPs();
				}

				if (keys[KEY_SLIDE_LEFT]) {
					Client.current_unit.slideLeftIfEnoughAPs();
				} else if (keys[KEY_SLIDE_RIGHT]) {
					Client.current_unit.slideRightIfEnoughAPs();
				}

			}
		}

		if (keys[KEY_ZOOM_IN]) {
			camera.zoomIn();
		} else if (keys[KEY_ZOOM_OUT]) {
			camera.zoomOut();
		}

		if (keys[KEY_PAN_FWD]) {
			camera.panForwards();
		} else if (keys[KEY_PAN_BACK]) {
			camera.panBackwards();
		}
	}

	private void decodeData() throws IOException, InstantiationException, IllegalAccessException, ClassNotFoundException {
		while (netClient.getInput().available() > 0) {
			byte b = netClient.getInput().readByte();
			if (Client.SHOW_COMMS) {
				System.out.println("Received cmd: " + b);
			}
			switch (b) {
			case S2CCommunication.GAME_DATA:
				S2CCommunication.DecodeGameData();
				break;
			case S2CCommunication.NEW_MAP:
				S2CCommunication.DecodeNewMap();
				break;
			case S2CCommunication.MSG:
				S2CCommunication.DecodeMessage();
				break;
			case S2CCommunication.ITEM_LIST:
				S2CCommunication.DecodeItemsForTrooper();
				break;
			case S2CCommunication.CAN_SEE_ENEMY:
				S2CCommunication.DecodeCanSeeEnemy();
				break;
			case S2CCommunication.AMMO_LEVEL:
				S2CCommunication.DecodeAmmoLevel();
				break;
			case S2CCommunication.ARMOUR_LEVEL:
				S2CCommunication.DecodeArmourLevel();
				break;
			case S2CCommunication.HEALTH_LEVEL:
				S2CCommunication.DecodeHealthLevel();
				break;
			case S2CCommunication.TROOPER_STATS:
				S2CCommunication.DecodeTrooperStats();
				break;
			case S2CCommunication.TIME_ELAPSED:
				S2CCommunication.DecodeElapsedTime();
				break;
			case S2CCommunication.REMOVE_ITEM:
				S2CCommunication.DecodeRemoveItem();
				break;
			case S2CCommunication.NEW_OBJECT:
				S2CCommunication.DecodeNewObject(netClient);
				break;
			case S2CCommunication.UPDATE_OBJECT:
				S2CCommunication.DecodeObjectUpdate(netClient);
				//return; // So the graphics are updated
				break;
			case S2CCommunication.UPDATE_ANGLE:
				S2CCommunication.DecodeObjectTurnUpdate(netClient);
				break;
			case S2CCommunication.REMOVE_OBJECT:
				S2CCommunication.DecodeRemoveObject();
				break;
			case S2CCommunication.APS:
				S2CCommunication.DecodeAPs();
				break;
			case S2CCommunication.EXPLOSION:
				S2CCommunication.DecodeExplosion();
				break;
			case S2CCommunication.WINNER:
				S2CCommunication.DecodeWinner();
				break;
			case S2CCommunication.AUTOFIRE:
				S2CCommunication.DecodeAutofire();
				break;
			case S2CCommunication.ANIMATE_MOVEMENT:
				S2CCommunication.DecodeAnimate(netClient);
				break;
			case S2CCommunication.GUARD:
				S2CCommunication.DecodeGuard();
				break;
			case S2CCommunication.MAPSQUARE_CHANGE:
				S2CCommunication.DecodeMapSquareChange(netClient);
				break;
			case S2CCommunication.VP_UPDATE:
				S2CCommunication.DecodeVPs(netClient);
				break;
			case S2CCommunication.SCENERY:
				S2CCommunication.DecodeScenery();
				break;
			case S2CCommunication.PLAYERS_NAME:
				S2CCommunication.DecodePlayersName();
				break;
			case S2CCommunication.PING_REPLY:
				S2CCommunication.DecodePingReply();
				break;
			case S2CCommunication.YOUR_ID_IS:
				S2CCommunication.DecodeMyID();
				break;
			case S2CCommunication.NEW_PLAYER:
				S2CCommunication.DecodeNewPlayer();
				break;
			case S2CCommunication.DESELECT_UNIT:
				S2CCommunication.DecodeDeselectUnit();
				break;
			case S2CCommunication.SELECT_UNIT:
				S2CCommunication.DecodeSelectUnit();
				break;
			case S2CCommunication.SIDE_OPTIONS:
				QuadByte qbyte = S2CCommunication.DecodeSideOptions();
				current_menu = new mnuSelectSide(canvas, qbyte);
				break;
			case S2CCommunication.SET_GHOST_MODE:
				S2CCommunication.DecodeSetGhostMode();
				break;
			case S2CCommunication.PLAY_SOUND:
				S2CCommunication.DecodePlaySound();
				break;
			case S2CCommunication.BULLET_MOVEMENT:
				S2CCommunication.DecodeBulletMovement(Client.netClient);
				break;
			case S2CCommunication.SIDE_IS_CPU_CONTROLLED:
				S2CCommunication.DecodeSideIsCPUControlled();
				break;
			case S2CCommunication.SERVER_VERSION:
				S2CCommunication.DecodeServerVersion();
				break;
			default:
				System.err.println("Unknown data: " + b);
			if (Client.netClient.getInput().available() > 0) {
				while (Client.netClient.getInput().readByte() != S2CCommunication.CHECK) {
					System.out.println("Skipping byte");
				}
			}
			}
		}
	}

	public static byte GetMyVPs() {
		return side_data.getVPs(players.getThisPlayer().side);
	}

	public static byte GetVPs(byte side) {
		if (side_data != null) {
			return side_data.getVPs(side);
		} else {
			return (byte)-1;
		}
	}

	public static void SetVPs(byte side, byte amt) {
		if (side_data != null) {
			side_data.setVPs(side, amt);
		}
	}

	public static void showChangeItemSelector() {
		if (Client.current_unit != null) {
			current_menu = new mnuChangeItem(canvas, current_unit);
		}
	}

	public void showUnitOptions() {
		if (Client.current_unit != null) {
			current_menu = new mnuUnitOptions(canvas);
		}
	}

	public static void setMenu(GLMenu menu) {
		current_menu = menu;
	}

	public static Color GetColourFromSide(byte s) {
		switch (s) {
		case Client.ATTACKER:
			return Color.yellow;
		case Client.DEFENDER:
			return Color.green;
		default:
			return Color.black;
		}
	}


	public void windowClosing(WindowEvent e) {
		quit_now = true;
	}

	/**
	 * This should only be called once.  If you
	 * wish to quit, set quit_now = true;
	 *
	 */
	public static void QuitNow() {
		try {
			C2SCommunication.SendDisconnect();
			netClient.close();
		} catch (IOException ex) {
			//ex.printStackTrace();
		}
		if (canvas != null) {
			canvas.stopAnim();
		}
		System.exit(0);
	}

	private void jbInit() throws Exception {
		this.addWindowFocusListener(new Client_this_windowFocusAdapter(this));
		this.addComponentListener(new Client_this_componentAdapter(this));
	}

	public void windowIconified(WindowEvent e) {
		//System.out.println("Anim stopped.");
		//anim.stop(); // Makes the game freeze once re-started
		Canvas3D.draw_gl = false;
	}

	public void windowDeiconified(WindowEvent e) {
		//System.out.println("Anim started.");
		//anim.start(); // Makes the game freeze once re-started
		Canvas3D.draw_gl = true;
	}

	void this_componentResized(ComponentEvent e) {
		Thread.yield();
		this.requestFocus();
	}

	void this_windowGainedFocus(WindowEvent e) {
		this.requestFocus();
	}

	void this_windowLostFocus(WindowEvent e) {
	}

	public void windowActivated(WindowEvent e) {
		this.requestFocus();
	}

	/* (non-Javadoc)
	 * @see ssmith.opengl.IManualDraw#drawGL(net.java.games.jogl.GL, net.java.games.jogl.GLU)
	 */
	public void drawGL(GL gl, GLU glu) {
		if (Client.current_unit != null) {
			if (camera.isLockedToTrooper()) {
				current_unit.drawCrossHairs(gl, glu);
			}
		}

		if (current_menu != null) {
			current_menu.draw(gl, glu, 400);
		}

		// On-screen text
		gl.glColor3f(1f, 1f, 0f);
		canvas.startTextMode(gl, glu);
		if (current_unit != null) {
			if (current_unit.getAPs() <= 1) {
				canvas.writeString(gl, 400, 200, GL_FONT, "This unit is out of APs!  Press 'N' to select next unit.");
			}
		}

		if (winner_text.length() > 0) {
			canvas.writeString(gl, 400, 300, GL_FONT, winner_text);
		}

		gl.glColor3f(0f, 1f, 0f);
		int x = this.getWidth() - 180;
		if (str_view_mode_text.length() > 0) {
			canvas.writeString(gl, x, 20, GL_FONT, str_view_mode_text);
		}
		if (Client.players.getThisPlayer().side >= 0) {
			canvas.writeString(gl, x, 40, GL_FONT,
					"VPs: " +
					Client.GetVPs(Client.players.getThisPlayer().
							side));
		}
		canvas.writeString(gl, x, 60, GL_FONT,
				"Time: " + Client.elapsed_time);
		canvas.writeString(gl, x, 80, GL_FONT, "Ping: " + ping_test.getPing());
		if (Client.DEBUG) {
			if (Canvas3D.draw_time != 0) {
				canvas.writeString(gl, x, 100, GL_FONT,
						"FPS: " + (1000 / Canvas3D.draw_time));
			}
		}
		canvas.writeString(gl, x, 120, GL_FONT,
				"Real Time: " +
				TimeFunctions.
				getMMSSFromLong(System.currentTimeMillis() -
						this.connected_time));
		if (Client.current_unit != null) {
			canvas.writeString(gl, 20, 20, GL_FONT, "Selected Unit: " + Client.current_unit.name);
			canvas.writeString(gl, 20, 40, GL_FONT,
					"Health: " + Client.current_unit.getHealth());
			canvas.writeString(gl, 20, 60, GL_FONT,
					"Action Points Left: " +
					(int) Client.current_unit.getAPs());
			canvas.writeString(gl, 20, 80, GL_FONT,
					"Armour: " +
					Client.current_unit.armour_damage_reduction);
			if (current_unit.getCurrentItem() != null) {
				canvas.writeString(gl, 20, 100, GL_FONT,
						"Weapon: " +
						Client.current_unit.getCurrentItem().name);
				canvas.writeString(gl, 20, 120, GL_FONT,
						"Ammo: " +
						Client.current_unit.getCurrentItem().ammo);
				if (Client.current_unit.isAutofiring()) {
					canvas.writeString(gl, 20, 140, GL_FONT, "Autofire: ON");
				} else {
					canvas.writeString(gl, 20, 140, GL_FONT, "Autofire: Off");
				}
				canvas.writeString(gl, 20, 180, GL_FONT,
						current_unit.getShotTypeName());
			}
			if (Client.current_unit.isGuarding()) {
				canvas.writeString(gl, 20, 160, GL_FONT, "Guarding: ON");
			} else {
				canvas.writeString(gl, 20, 160, GL_FONT, "Guarding: Off");
			}
		} else if (Client.ghost_mode) {
			if (Client.camera.getViewer() != null) {
				CPlayerObject3D unit = (CPlayerObject3D)Client.camera.
				getViewer();
				canvas.writeString(gl, 20, 20, GL_FONT,
						"Viewing from " +
						unit.name);
			}
		}

		Client.log.draw(gl);

		if (Client.tutor.activated) {
			gl.glColor3f(0.9f, .5f, .5f);
			canvas.writeString(gl, 20, 270, GL_FONT, tutor.getWords());
		}

		canvas.finishTextMode(gl);
	}

	public static void HandleError(Exception ex) {
		System.err.println(new Date().toString());
		System.err.println("Error:" + ex.getMessage());
		ex.printStackTrace();
		Functions.LogStackTrace(ex, EXCEPTION_FILE);
	}

	public static void redrawMapDisplay() {
		hud_panel.redrawMapImage();
	}

	public static void removeMenu() {
		current_menu = null;
	}

	public static void setGhostMode(boolean b) throws IOException {
		if (b != ghost_mode) {
			if (b) {
				C2SCommunication.SendDeselectCurrentUnit();
				Client.log.addMessage("Entering Ghost mode", (byte)1);
				Client.str_view_mode_text = "GHOST MODE";
				selectNextGhostUnit();
			} else {
				Client.current_unit = null;
				Client.str_view_mode_text = "";
				Client.log.addMessage("Left Ghost mode", (byte)1);
				C2SCommunication.SendSelectNextUnit();
			}
			ghost_mode = b;
		}
	}

	public static boolean isInGhostMode() {
		return ghost_mode;
	}

	public static int getMapSize() {
		return map.getMapSize();
	}

	public static void setElapsedTime(int t) {
		elapsed_time = t;
	}

	public static void setWinnerText(String s) {
		winner_text = s;
	}

	public static void StartNewGame() {
		//System.out.println("Starting new game");

		canvas.removeAllObjects();

		if (coll_matrix != null) {
			coll_matrix.removeAllObjects();
		}
		objects = new CObject[Server.START_OBJECTS];
		client_processed_objects.removeAll(client_processed_objects);
		units_on_my_side.removeAll(units_on_my_side);
		elapsed_time = 0;
		side_data = new CSideData();
		current_unit = null;
		winner_text = "";

		System.gc();
	}

}

class Client_this_componentAdapter extends java.awt.event.ComponentAdapter {
	Client adaptee;

	Client_this_componentAdapter(Client adaptee) {
		this.adaptee = adaptee;
	}

	public void componentResized(ComponentEvent e) {
		adaptee.this_componentResized(e);
	}
}

class Client_this_windowFocusAdapter implements
java.awt.event.WindowFocusListener {
	Client adaptee;

	Client_this_windowFocusAdapter(Client adaptee) {
		this.adaptee = adaptee;
	}

	public void windowGainedFocus(WindowEvent e) {
		adaptee.this_windowGainedFocus(e);
	}

	public void windowLostFocus(WindowEvent e) {
		adaptee.this_windowLostFocus(e);
	}
}
