package ngrave.client;

import ngrave.client.objects.CPlayerObject3D;
import ssmith.lang.Functions;
import ssmith.opengl.Canvas3D;
import ssmith.opengl.ICamera;
import ssmith.opengl.Vector;

public final class Camera implements ICamera {

  public static final int VIEW_NORMAL = 0, VIEW_TOP_DOWN = 1, VIEW_CINEMA=2;
  private static final float CAMERA_MOVE_SPEED = 0.5f;

  private CPlayerObject3D trooper;
  private Vector current_view_from; // Where the camera is currently located
  private Vector current_view_to; // where we aim to look at
  private Vector target_view_from; // Where the camera wants to be
  private Vector target_view_to; // where we aim to look at
  private Vector orientation;
  private int view_mode = VIEW_NORMAL;
  private float zoom = 10;
  private boolean locked_to_trooper = false;
  private float pan_dist=2f; // distance forward the camera looks

  public Camera() {
    current_view_from = new Vector(20, Client.MAX_VIEW_DIST, 20); // SO we swoop in at the start
    target_view_from = new Vector();
    current_view_to = new Vector();
    target_view_to = new Vector();
    orientation = new Vector(0f, 1f, 0f);

	//Client.canvas.setMaxViewDist(200f); // So the swoop-down works
  }

  public void process() {
    if (Canvas3D.is_drawing) {
      // Set view from
      if (trooper != null) {
    	  // Set the view from
      	if (view_mode != VIEW_CINEMA) {
	        this.target_view_from.x = trooper.getX();
	        this.target_view_from.z = trooper.getZ();
      	} else {
	        if (Functions.mod(this.target_view_from.x - trooper.getX()) > 5f) {
	        	if (this.target_view_from.x > trooper.getX()) {
	        		this.target_view_from.x -= 10f;
	        	} else {
	        		this.target_view_from.x += 10f;
	        	}
	        }
	        if (Functions.mod(this.target_view_from.z - trooper.getZ()) > 5f) {
	        	if (this.target_view_from.z > trooper.getZ()) {
	        		this.target_view_from.z -= 10f;
	        	} else {
	        		this.target_view_from.z += 10f;
	        	}
	        }
      	}
        if (view_mode == VIEW_NORMAL) {
          // Set the view from the current troopers eyes
          this.target_view_from.y = trooper.y_pos;
        }
        else { // From above the trooper
          target_view_from.y = zoom;
        }

        // Set the view target:-
      	if (view_mode != VIEW_CINEMA) {
	        float x = (float) (Math.cos(Math.toRadians(270 - trooper.y_angle))) * pan_dist;
	        float z = (float) (Math.sin(Math.toRadians(270 - trooper.y_angle))) * pan_dist;

	        target_view_to.x = trooper.getX() + x;
	        target_view_to.y = trooper.y_pos; // Look at same height
	        target_view_to.z = trooper.getZ() + z;
      	} else {
	        target_view_to.x = trooper.getX();
	        target_view_to.y = trooper.y_pos;
	        target_view_to.z = trooper.getZ();
      	}
      }

      // System.out.print("Actual: " +current_view_from.x + " " +current_view_from.y + " " + current_view_from.z + "  ");
      //System.out.println("Actual: " +current_view_to.x + " " +current_view_to.y + " " + current_view_to.z);

      // move camera to desired location.
      if (locked_to_trooper) {
        this.current_view_from.x = this.target_view_from.x;
        this.current_view_from.y = this.target_view_from.y;
        this.current_view_from.z = this.target_view_from.z;

        this.current_view_to.x = this.target_view_to.x;
        this.current_view_to.y = this.target_view_to.y;
        this.current_view_to.z = this.target_view_to.z;
      }
      else {
        if (current_view_from.x != target_view_from.x) {
          if (ssmith.lang.Functions.mod(current_view_from.x -
                                        target_view_from.x) <
              CAMERA_MOVE_SPEED) {
            current_view_from.x = target_view_from.x;
          }
          else {
            if (current_view_from.x > target_view_from.x) {
              current_view_from.x = current_view_from.x - CAMERA_MOVE_SPEED;
            }
            else {
              current_view_from.x = current_view_from.x + CAMERA_MOVE_SPEED;
            }
          }
        }

        if (current_view_from.y != target_view_from.y) {
          if (ssmith.lang.Functions.mod(current_view_from.y -
                                        target_view_from.y) <
              CAMERA_MOVE_SPEED) {
            current_view_from.y = target_view_from.y;
          }
          else {
            if (current_view_from.y > target_view_from.y) {
              current_view_from.y = current_view_from.y - CAMERA_MOVE_SPEED;
            }
            else {
              current_view_from.y = current_view_from.y + CAMERA_MOVE_SPEED;
            }
          }
        }

        if (current_view_from.z != target_view_from.z) {
          if (ssmith.lang.Functions.mod(current_view_from.z -
                                        target_view_from.z) <
              CAMERA_MOVE_SPEED) {
            current_view_from.z = target_view_from.z;
          }
          else {
            if (current_view_from.z > target_view_from.z) {
              current_view_from.z = current_view_from.z - CAMERA_MOVE_SPEED;
            }
            else {
              current_view_from.z = current_view_from.z + CAMERA_MOVE_SPEED;
            }
          }
        }

        // move target_view to desired location.
        if (current_view_to.x != target_view_to.x) {
          if (ssmith.lang.Functions.mod(current_view_to.x - target_view_to.x) <
              CAMERA_MOVE_SPEED) {
            current_view_to.x = target_view_to.x;
          }
          else {
            if (current_view_to.x > target_view_to.x) {
              current_view_to.x = current_view_to.x - CAMERA_MOVE_SPEED;
            }
            else {
              current_view_to.x = current_view_to.x + CAMERA_MOVE_SPEED;
            }
          }
        }

        if (current_view_to.y != target_view_to.y) {
          if (ssmith.lang.Functions.mod(current_view_to.y - target_view_to.y) <
              CAMERA_MOVE_SPEED) {
            current_view_to.y = target_view_to.y;
          }
          else {
            if (current_view_to.y > target_view_to.y) {
              current_view_to.y = current_view_to.y - CAMERA_MOVE_SPEED;
            }
            else {
              current_view_to.y = current_view_to.y + CAMERA_MOVE_SPEED;
            }
          }
        }

        if (current_view_to.z != target_view_to.z) {
          if (ssmith.lang.Functions.mod(current_view_to.z - target_view_to.z) <
              CAMERA_MOVE_SPEED) {
            current_view_to.z = target_view_to.z;
          }
          else {
            if (current_view_to.z > target_view_to.z) {
              current_view_to.z = current_view_to.z - CAMERA_MOVE_SPEED;
            }
            else {
              current_view_to.z = current_view_to.z + CAMERA_MOVE_SPEED;
            }
          }
        }

        this.locked_to_trooper = this.isAtEyeLevel();
      }
    }
  }

  public boolean isLockedToTrooper() {
      //return this.locked_to_trooper && Client.current_unit != null;
      return this.locked_to_trooper && trooper != null;
  }

  private boolean isAtEyeLevel() {
    if (trooper != null) {
      return this.view_mode == VIEW_NORMAL &&
          this.current_view_from.x == this.trooper.getX() &&
          this.current_view_from.y == trooper.y_pos &&
          this.current_view_from.z == this.trooper.getZ();
    } else {
      return false;
    }
  }

  public void showFromTrooper(CPlayerObject3D obj) {
    this.trooper = obj;

    if (this.view_mode != Camera.VIEW_CINEMA) {
        if (trooper != null) {
            this.target_view_from.x = trooper.getX();
            //this.target_view_from.y = trooper.y_pos;
            this.target_view_from.z = trooper.getZ();
        }
    } else {
    	this.showCinemaView();
    }

    this.target_view_to.x = trooper.getX();
    //this.target_view_to.y = trooper.y_pos;
    this.target_view_to.z = trooper.getZ();

    //showFromTrooper(); - no - keep in map mode (if so).
    Client.map.recalcVisibleSquares(true, false);
  }

  public CPlayerObject3D getViewer() {
    return this.trooper;
  }

  public int getViewMode() {
    return this.view_mode;
  }

  public void toggleView() {
    if (this.view_mode == VIEW_NORMAL) {
      this.showTopDown();
      Client.str_view_mode_text = "Map View";
    } else if (this.view_mode == VIEW_TOP_DOWN) {
        this.showCinemaView();
        Client.str_view_mode_text = "Cinema View";
    } else {
        this.view_mode = VIEW_NORMAL;
        setViewDistance();
      Client.str_view_mode_text = "Normal View";
    }

  }

  private void setViewDistance() {
    if (getViewMode() != Camera.VIEW_NORMAL) {
        Client.canvas.setMaxViewDist(200f);
	} else {
        Client.canvas.setMaxViewDist(Client.MAX_VIEW_DIST);
	}

  }

  public void showTopDown() {
    this.view_mode = VIEW_TOP_DOWN;
    locked_to_trooper = false;

    this.target_view_from.y = zoom;

    this.target_view_to.y = 0;
    setViewDistance();
  }

  public void showCinemaView() {
	  if (this.getViewer() != null) {
	    this.view_mode = VIEW_CINEMA;
	    locked_to_trooper = false;

	    this.target_view_from.x = this.getViewer().getX() + Functions.rnd(-10, 10);
		this.target_view_from.y = Functions.rndFloat(5f, zoom);
	    this.target_view_from.z = this.getViewer().getZ() + Functions.rnd(-10, 10);

	    this.target_view_to.y = 0;
	    setViewDistance();
	  } else {
		  showTopDown();
	  }
  }

	/* (non-Javadoc)
	 * @see ssmith.opengl.ICamera#getViewFrom()
	 */
	public Vector getViewFrom() {
		return current_view_from;
	}

	/* (non-Javadoc)
	 * @see ssmith.opengl.ICamera#getViewTo()
	 */
	public Vector getViewTo() {
		return current_view_to;
	}

    public void zoomIn() {
        if (zoom > 1) {
            zoom = zoom - 0.5f;
        }

    }

    public void zoomOut() {
        if (zoom < 60f) {
            zoom = zoom + 0.5f;
        }

    }

    public void panForwards() {
        if (pan_dist < Client.getMapSize()) {
            pan_dist = pan_dist + 1f;
        }
    }

    public void panBackwards() {
        if (pan_dist > 1) {
            pan_dist = pan_dist - 1f;
        }
    }

    public Vector getOrientation() {
        return orientation;
    }

}
