package ngrave.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.ListIterator;
import ngrave.server.ServerFunctions;

public final class CPlayers {

	private ArrayList player_data = new ArrayList();
    private CPlayerData this_player;

	public CPlayers() {
		super();
	}

	/**
	 * This is for adding a new remote player
	 * @param id
	 * @throws IOException
	 */
	public void addPlayer(int id) throws IOException {
		/*CPlayerData pdata = new CPlayerData();
        pdata.id = id;
		player_data.add(pdata);

        if (player_data.size() == 1) {
            this_player = (CPlayerData)player_data.get(0);
        }*/
		this.addPlayer(id, null, (byte)-1);
	}

	/**
	 * This is for adding us directly as we know about ourselves.
	 * @param id
	 * @param name
	 * @param side
	 * @throws IOException
	 */
	public void addPlayer(int id, String name, byte side) throws IOException { //
		CPlayerData pdata = new CPlayerData();
        pdata.id = id;
        pdata.setName(name);
        pdata.side = side;
		player_data.add(pdata);

		if (Client.DEBUG) {
			System.out.println("New player: " + name);
		}

        if (player_data.size() == 1) {
            this_player = (CPlayerData)player_data.get(0);
        } else {
        	Client.log.addMessage(name + " joined the " + ServerFunctions.getSideName(side) + "s.", (byte)0);
        }
	}

    public CPlayerData getThisPlayer() {
        return this_player;
    }

    public CPlayerData getPlayerByID(int id) {
        ListIterator enumr = this.player_data.listIterator();
        CPlayerData pdata;
        while (enumr.hasNext()) {
            pdata = (CPlayerData)enumr.next();
            if (pdata.id == id) {
                return pdata;
            }
        }
        System.err.println("Player id " + id + " not found.");
        return null;
    }

    public ListIterator getIterator() {
    		return player_data.listIterator();
    }

}
