package ngrave.client;

import java.io.*;

import ssmith.opengl.I3DObject;
import ssmith.util.Interval;

import net.java.games.jogl.*;
import ngrave.client.objects.CMapSquare;
import ngrave.client.objects.CMapSquareWall;
import ngrave.server.SMapSquare;

public final class CMapData implements I3DObject {

    private byte size;
    public final CMapSquare map[][];
    private boolean map_received = false; // So we don't try to optimize or recalc visible squares before the whole map is created.
    private Interval recalc_interval = new Interval(1000);
    private CMapSquareWall dummy_wall;

    public CMapData(byte size) {
        this.size = size;
        map = new CMapSquare[size][size];
        dummy_wall = new CMapSquareWall((byte)-1, (byte)-1);
    }

    public boolean wholeMapReceived() {
        return map_received;
    }

    public CMapSquare getMapSquare(float x, float z) {
        return this.getMapSquare((int)x, (int)z);
    }

    public CMapSquare getMapSquare(int x, int z) {
        try {
        	if (x >= 0 && z >= 0) {
        		return map[x][z];
        	} else {
                return dummy_wall;
        	}
        } catch (ArrayIndexOutOfBoundsException ex) {
            return dummy_wall;
        }
    }

    public void setMapSquareType(byte x, byte z, byte type, boolean damaged, boolean blocks_move, boolean blocks_targets, boolean blocks_scenery) throws IOException {
        byte old_type = -1;
        if (this.map[x][z] != null) {
            old_type = this.map[x][z].type;
        }
        CMapSquare.MapSquareFactory(x, z, type, damaged, blocks_move, blocks_targets, blocks_scenery);

        // Have we received the whole map?
        if (x == size-1 && z == size - 1) {
            map_received = true;
            this.optimizeMap();
        } else if (map_received) {
            recalcVisibleSquares(true, false);
            if (old_type == SMapSquare.WALL) {
                // Readjust map optimizations
                this.optimizeMapSquare((byte)(x-1), z);
                this.optimizeMapSquare((byte)(x+1), z);
                this.optimizeMapSquare(x, (byte)(z-1));
                this.optimizeMapSquare(x, (byte)(z+1));
                Client.redrawMapDisplay();
            } else if (map_received && (old_type == SMapSquare.ATTACKER_COMPUTER || old_type == SMapSquare.DEFENDER_COMPUTER)) {
                Client.redrawMapDisplay();
            }
        }
    }

    public void recalcVisibleSquares(boolean regardless_of_interval, boolean only_check_angle) {
        if (map_received == false) {
            return;
        }
        if (recalc_interval.hitInterval() || regardless_of_interval) {
            if (Client.camera.getViewer() != null) {
                byte start_z = (byte)(Client.camera.getViewer().getZ() - (Client.MAX_VIEW_DIST));
                byte end_z = (byte)(Client.camera.getViewer().getZ() + (Client.MAX_VIEW_DIST));
                byte start_x = (byte)(Client.camera.getViewer().getX() - (Client.MAX_VIEW_DIST));
                byte end_x = (byte)(Client.camera.getViewer().getX() + (Client.MAX_VIEW_DIST));
                for(byte z=start_z ; z<end_z ; z++) {
                    for (byte x=start_x; x<end_x ; x++) {

                //for(byte z=0 ; z<size ; z++) {
                  //  for (byte x=0; x<size ; x++) {
                        if (x>= 0 && x < size) {
                    if (z>= 0 && z < size) {
                        if (map[x][z] != null) {
                            if (Client.camera.getViewer().distanceTo(map[x][z]) <=
                                3) { // Show all close squares anyway
                                map[x][z].setCanBeSeen(true);
                            } else {
                                map[x][z].setCanBeSeen(Client.camera.getViewer().
                                        canSee(map[x][z], only_check_angle));
                            }
                        }
                    }
                        }
                    }
                }
            }
        }
    }

    public void draw(GL gl, GLU glu) {
        boolean locked_to_trooper = Client.camera.isLockedToTrooper();
        int count=0;
        if (Client.camera.getViewer() == null) {
        	return;
        }
        byte start_z = (byte)(Client.camera.getViewer().getZ() - (Client.MAX_VIEW_DIST));
        byte end_z = (byte)(Client.camera.getViewer().getZ() + (Client.MAX_VIEW_DIST));
        byte start_x = (byte)(Client.camera.getViewer().getX() - (Client.MAX_VIEW_DIST));
        byte end_x = (byte)(Client.camera.getViewer().getX() + (Client.MAX_VIEW_DIST));
        for(byte z=start_z ; z<end_z ; z++) {
            for (byte x=start_x; x<end_x ; x++) {

        //for(byte z=0 ; z<size ; z++) {
          //  for (byte x=0; x<size ; x++) {
                if (x>= 0 && x < size) {
                    if (z>= 0 && z < size) {
                        if (map[x][z] != null) {
                            if (!locked_to_trooper || map[x][z].canBeSeen()) {
                                map[x][z].draw(gl, glu);
                                count++;
                            }
                        }
                    }
                }
            }
        }
        //System.out.println("Count: " + count);
    }

    private void optimizeMap() {
        for(int z=1 ; z<size-1 ; z++) {
            for (int x =1; x < size-1 ; x++) {
                if (map[x][z] instanceof CMapSquareWall) {
                    CMapSquareWall sq = (CMapSquareWall)map[x][z];
                    if (map[x - 1][z].type == SMapSquare.WALL) {
                        sq.draw_w = false;
                    }
                    if (map[x + 1][z].type == SMapSquare.WALL) {
                        sq.draw_e = false;
                    }
                    if (map[x][z - 1].type == SMapSquare.WALL) {
                        sq.draw_n = false;
                    }
                    if (map[x][z + 1].type == SMapSquare.WALL) {
                        sq.draw_s = false;
                    }
                }
            }
        }
    }

    private void optimizeMapSquare(byte x, byte z) {
        if (map_received) {
            if (x >= 0 && x <= size - 1 && z >= 0 && z <= size - 1) {
                if (this.map[x][z] instanceof CMapSquareWall) {
                    CMapSquareWall sq = (CMapSquareWall)this.map[x][z];
                    sq.draw_n = true;
                    sq.draw_s = true;
                    sq.draw_e = true;
                    sq.draw_w = true;
                    if (map[sq.x - 1][sq.z].type == SMapSquare.WALL) {
                        sq.draw_w = false;
                    }
                    if (map[sq.x + 1][sq.z].type == SMapSquare.WALL) {
                        sq.draw_e = false;
                    }
                    if (map[sq.x][sq.z - 1].type == SMapSquare.WALL) {
                        sq.draw_n = false;
                    }
                    if (map[sq.x][sq.z + 1].type == SMapSquare.WALL) {
                        sq.draw_s = false;
                    }
                }
            }
        }
    }

    /* (non-Javadoc)
     * @see ssmith.opengl.I3DObject#shouldBeDrawn()
     */
    public boolean shouldBeDrawn() {
        return true;
    }

    public int getMapSize() {
        return this.size;
    }
}
