package ngrave.client;

import java.io.*;

import net.java.games.jogl.*;
import ngrave.misc.ItemsFile;

/**
 * This is for client to select different items, and show basic details like ammo, name.
 * This is used by all items that can be carried.
 */
public class CItemCarried {

  public byte type;
  public int no, ammo;
  public String name, desc;

  public CItemCarried(byte type, int no, int ammo) throws IOException {
    this.type = type;
    this.no = no;
    this.ammo = ammo;
    ItemsFile file = new ItemsFile();
    file.getStatsFromCSVFile(type);
    this.name = file.name;
    this.desc = file.desc;
  }

  public String getInfo() {
    return desc;
  }

  /**
   * Override for when drawing the item being carried.
   */
  public void drawCarried(GL gl, GLU glu) {

  }

}
