package ngrave.ai;

import ngrave.client.Client;
import ngrave.server.SMapSquare;
import ngrave.server.Server;
import ngrave.server.objects.SPlayerObject3D;
import ssmith.lang.Functions;

public class Wander90AI extends AI {

  private int target_angle;
  private boolean turn_next_square = false;

  public Wander90AI(SPlayerObject3D po) {
    super(po);
  }

  public void performNonCombatAI() {
    if (trooper.isWithinAngle(target_angle, Client.TURN_SPEED) == false) {
      trooper.turnIfEnoughAPs(Functions.sign(target_angle - trooper.getAngle()) * Client.TURN_SPEED, false);
    } else {
      trooper.turnIfEnoughAPs(target_angle, true); // Align us by the last few degrees
      if (trooper.moveForwardsIfEnoughAPs().moveSuccessful() == false) {
        // Is it a door?
        SMapSquare sq = trooper.getFacingMapSquare();
        if (sq.getType() == SMapSquare.CLOSED_DOOR) {
          if (trooper.getAPs() >= SPlayerObject3D.OPEN_DOOR_COST) {
            Server.map.openDoor(sq);
            trooper.reduceAPs(SPlayerObject3D.OPEN_DOOR_COST, false);
          }
        } else {
          this.target_angle += 180; // turn us round.
          if (this.target_angle > 360) {
          	this.target_angle -= 360;
          }
          turn_next_square = true;
        }
      } else {
        // New direction
        if (trooper.isInMiddleOfSquare()) {
          if (turn_next_square || Functions.rnd(1, 5) == 1) {
          	turn_next_square = false;
            this.getNewAngle();
          }
        }
      }
    }
  }

  private void getNewAngle() {
    this.target_angle = Functions.rnd(0, 3) * 90;
  }

}
