/*
 * Created on Sep 25, 2005
 *
 */
package ngrave.ai;

import java.awt.Point;
import java.util.ArrayList;

import ngrave.client.Client;
import ngrave.server.objects.SPlayerObject3D;
import ssmith.astar.WayPoints;

/**
 * @author Stephen Smith
 *
 */
public class HuntForAIGroup {

	public SPlayerObject3D master_target;
	private WayPoints all_locations; // Locations to look in.
	private WayPoints remaining_locations; // Locations to look in.
	private ArrayList members = new ArrayList();
	
	/**
	 * 
	 */
	public HuntForAIGroup(SPlayerObject3D targ, WayPoints locs) {
		super();
		this.master_target = targ;
		this.all_locations = locs;
		this.remaining_locations = locs.copy();
	}
	
	public void addMember(HuntForAI hfai) {
		members.add(hfai);
	}
	
	public void foundTarget() {
		if (Client.SHOW_AI) {
			System.out.println("Seen target!");
		}
		for(int a=0 ; a<members.size() ; a++) {
			HuntForAI hfai = (HuntForAI)members.get(a);
			hfai.enemy = this.master_target;
			hfai.calcRoute((int)this.master_target.getX(), (int)this.master_target.getZ(), -1);
		}
	}

	public Point getNextPoint() {
		// Refill the remaining locations if we've looked in them all.
		if (remaining_locations.size() == 0) {
			remaining_locations = (WayPoints) all_locations.copy();

		}
		Point next_location_to_look_in = remaining_locations.getRandomPoint();
		remaining_locations.remove(next_location_to_look_in);
		//System.out.println("Remaining locations: "+remaining_locations.size());
		return next_location_to_look_in;
	}
}
