/*
 * Created on 19-Sep-2005
 *
 */
package ngrave.ai;

import java.awt.Point;
import java.io.IOException;

import ngrave.server.objects.SPlayerObject3D;


/**
 * This is for looking for Sterner Regnix.
 *
 * @author stephen smith
 *
 */
public class HuntForAI extends AI {

	private Point next_location_to_look_in;
	private HuntForAIGroup group;

	/**
	 * @param po
	 * @throws IOException
	 */
	public HuntForAI(SPlayerObject3D po, HuntForAIGroup grp) {
		super(po);
		group = grp;
		group.addMember(this);
	}

	  public void doAI() {
	  	super.doAI();
	  	// If we can see the target, tell everyone else!
	  	if (this.trooper.canSee(group.master_target, true)) {
	  		if (enemy != group.master_target) {
	  			group.foundTarget();
	  		}
	  	}
	  }

	/* (non-Javadoc)
	 * @see ngrave.ai.AI#performNonCombatAI()
	 */
	protected void performNonCombatAI() {
      	//System.out.println("Non-combat.");
		// Get another point if we're not going anywhere
		if (this.route.hasAnotherPoint() == false) {
			next_location_to_look_in = group.getNextPoint();
			this.calcRoute(next_location_to_look_in, -1);
		} else {
			this.moveUsingAStar();
			// check if we've got to the location
			if((int)this.trooper.getX() == this.next_location_to_look_in.x) {
				if((int)this.trooper.getZ() == this.next_location_to_look_in.y) {
					next_location_to_look_in = group.getNextPoint();
					this.calcRoute(next_location_to_look_in, -1);
				}
			}
		}

	}

}
