package ngrave.ai;

import ssmith.lang.Functions;
import java.io.IOException;

import ngrave.client.Client;
import ngrave.server.objects.SPlayerObject3D;



/**
 * This AI shadows another trooper.
 */
public class FollowAI extends AI {

  private static final float MAX_DIST = 2;

  private SPlayerObject3D leader;

  public FollowAI(SPlayerObject3D po, SPlayerObject3D leader) throws IOException {
    super(po);
    this.leader = leader;
  }

  public void performNonCombatAI() {
    // Turn to face leader
    int ang = trooper.getAbsoluteAngleTo(leader);
    if (trooper.isWithinAngle(ang, Client.TURN_SPEED*2) == false) {
      trooper.turnIfEnoughAPs(Functions.sign(ang - trooper.getAngle()) * Client.TURN_SPEED, false);
    }
    if (trooper.distanceTo(leader) > MAX_DIST) {
      if (trooper.moveForwardsIfEnoughAPs().moveSuccessful() == false) {
        if (trooper.slideLeftIfEnoughAPs() == false) {
          trooper.slideRightIfEnoughAPs();
        }
      }
    }
  }

}