/*
 * Created on Oct 15, 2005
 *
 */
package ngrave.ai;

import java.awt.Point;
import java.util.ArrayList;

import ngrave.server.objects.SPlayerObject3D;

import ssmith.astar.WayPoints;
import ssmith.lang.Functions;

/**
 * @author Stephen Smith
 *
 */
public class EscortGroupAI {
	
	public static final float FOLLOW_DIST = 3f;
	
	private SPlayerObject3D vip, current_bodyguard;
	private WayPoints escape_locations;
	private int curr_dest = -1;
	private ArrayList bodyguards = new ArrayList();

	/**
	 * 
	 */
	public EscortGroupAI(SPlayerObject3D vip, WayPoints escape_locs) {
		super();
		this.vip = vip;
		this.escape_locations = escape_locs;
	}
	
	public SPlayerObject3D getVIP() {
		return vip;
	}
	
	public SPlayerObject3D getCurrentBodyguard() {
		if (this.current_bodyguard == null) {
			this.setNewBodyguard();
		} else if (this.current_bodyguard.isDestroyed()) {
			this.bodyguards.remove(current_bodyguard);
			this.setNewBodyguard();
		}
		return current_bodyguard;
	}
	
	public void addBodyguard(SPlayerObject3D person) {
		this.bodyguards.add(person);
	}
	
	public int getNoOfBodyguards() {
		return this.bodyguards.size();
	}
	
	public Point getCurrDest() {
		if (curr_dest == -1) {
			// Choose a random exit
			curr_dest = Functions.rnd(0, escape_locations.size()-1);
		}
		return (Point)escape_locations.get(curr_dest);
	}
	
	public void setNewBodyguard() {
		if (this.bodyguards.size() > 0) {
			int pos = Functions.rnd(0, bodyguards.size()-1);
			this.current_bodyguard = (SPlayerObject3D) bodyguards.get(pos);
		} else {
			this.current_bodyguard = null;
		}
	}

}
