/*
 * Created on Oct 15, 2005
 *
 */
package ngrave.ai;

import java.awt.Point;

import ngrave.client.Client;
import ngrave.server.Server;
import ngrave.server.objects.SPlayerObject3D;

/**
 * @author Stephen Smith
 *
 */
public class EscortAI extends AI {

	private EscortGroupAI group;

	/**
	 *
	 */
	public EscortAI(SPlayerObject3D person, EscortGroupAI grp) {
		super(person);
		this.group = grp;
		if (person != group.getVIP()) {
			this.group.addBodyguard(person);
		}
	}

	/* (non-Javadoc)
	 * @see ngrave.ai.AI#performNonCombatAI()
	 */
	protected void performNonCombatAI() {
		Point dest = group.getCurrDest();
		// Are we the VIP?
		if (this.trooper == group.getVIP()) {
			// Are we on the way somewhere?
			if (this.route.hasAnotherPoint()) {
				super.moveUsingAStar();
			} else {
				// Can we see the exit?
				if (trooper.canSee(dest.x, dest.y, false)) {
					if (Client.SHOW_AI) {
						System.out.println(this.trooper.name + " can see the exit.");
					}
					trooper.turnToIfEnoughAPs(Server.map.getMapSquare(dest.x, dest.y));
					super.calcRoute(dest.x, dest.y, -1);
				} else {
					SPlayerObject3D bodyguard = group.getCurrentBodyguard();
					if (bodyguard != null) {
						if (this.trooper.distanceTo(bodyguard) > EscortGroupAI.FOLLOW_DIST) {
							super.calcRoute((int)bodyguard.getX(), (int)bodyguard.getZ(), -1);
						} else {
							trooper.ensureNoHoldup();
						}
					} else {
						// We're on our own!
						this.calcRoute(dest.x, dest.y, -1);
					}

				}
			}
		} else {
			if (this.route.hasAnotherPoint() == false) {
				this.calcRoute(dest.x, dest.y, -1);
			} else {
				this.moveUsingAStar();
			}
		}

	}

}
