/*
 * Created on Oct 1, 2005
 *
 */
package ngrave.ai;

import java.awt.Point;
import java.io.IOException;

import ngrave.client.Client;
import ngrave.server.SMapSquare;
import ngrave.server.Server;
import ngrave.server.objects.SPlayerObject3D;

import ssmith.util.Interval;


/**
 * @author stephen smith
 *
 */
public class DestroyComputersAI extends AI {

	private DestroyComputersAIGroup group;
	private Point next_computer_location;
	private Interval check_computer_interval;

	/**
	 * @param po
	 * @throws IOException
	 */
	public DestroyComputersAI(SPlayerObject3D po, DestroyComputersAIGroup grp) {
		super(po);
		this.group = grp;
		check_computer_interval = new Interval(5000);
	}

	  public void doAI() {
	  	super.doAI();
	  	// Check if we're facing a computer.
	  	SMapSquare sq = trooper.getFacingMapSquare();
	  	if (sq.getType() == SMapSquare.DEFENDER_COMPUTER || sq.getType() == SMapSquare.ATTACKER_COMPUTER) {
	  		trooper.performActionIfEnoughAPs();
	  		// Has it been turned off?
		  	sq = trooper.getFacingMapSquare();
		  	if (sq.getType() != SMapSquare.DEFENDER_COMPUTER && sq.getType() != SMapSquare.ATTACKER_COMPUTER) {
		  		this.group.remove(sq.x, sq.z);
		  		this.route.clear();
		  	}
	  	} else {
	  		// Check the computer we're going for hasn't been turned off by someone else
	  		if (check_computer_interval.hitInterval()) {
	  			if (next_computer_location != null) {
			  		if (this.group.contains(next_computer_location.x, next_computer_location.y) == false) {
			  			this.route.clear();
			  		}
	  			}
	  		}
	  	}
	  }

	/* (non-Javadoc)
	 * @see ngrave.ai.AI#performNonCombatAI()
	 */
	protected void performNonCombatAI() {
		if (group.hasAnotherPoint() == false) {
			// Run out of computers to turn off.
			this.trooper.setAI(new Wander90AI(this.trooper));
			return;
		}
      	//System.out.println("Non-combat.");
		// Get another point if we're not going anywhere
		if (this.route.hasAnotherPoint() == false) {
			next_computer_location = group.getClosestPoint((int)trooper.getX(), (int)trooper.getZ());
			this.calcRoute(next_computer_location, -1);
			/*if (this.getRoute(next_computer_location, -1) == false) {
				// Can't get to it for some reason.  Maybe completely blocked.
				group.remove(next_computer_location);
			}*/
		} else {
			this.moveUsingAStar();
		}
	}

	  public boolean isMapSquareTraversable(int x, int z) {
	  	if (Server.map.getMapSquare(x, z).getType() == SMapSquare.DEFENDER_COMPUTER && trooper.side == Client.ATTACKER) {
	  		return true;
	  	} else if (Server.map.getMapSquare(x, z).getType() == SMapSquare.ATTACKER_COMPUTER && trooper.side == Client.DEFENDER) {
		  		return true;
	  	} else {
	  		return super.isMapSquareTraversable(x, z);
	  	}
	  }

}
