/*
 * Created on 19-Sep-2005
 *
 */
package ngrave.ai;

import java.io.IOException;

import ngrave.client.Client;
import ngrave.server.SMapSquare;
import ngrave.server.Server;
import ngrave.server.objects.SPlayerObject3D;

import ssmith.lang.Functions;
import ssmith.util.Interval;

/**
 * This AI is for generally wandering around unless they
 * see an enemy in which case they home-in.
 * @author stephen smith
 *
 */
public class AttackSquadAI extends AI {

	private AttackSquadAIGroup group;
	  private int target_angle;
	  private boolean turn_next_square = false;
	  private Interval inform_others_interval = new Interval(1000);


	/**
	 * @param po
	 * @throws IOException
	 */
	public AttackSquadAI(SPlayerObject3D po, AttackSquadAIGroup grp) {
		super(po);
		group = grp;
		group.addMember(this);
	}

	  public void doAI() {
	  	super.doAI();
	  	// If we can see the target, tell everyone else!
	  	if (this.enemy != null) {
	  		if (inform_others_interval.hitInterval()) {
	  			group.foundTarget(this.enemy);
	  		}
	  	}
	  }

	/* (non-Javadoc)
	 * @see ngrave.ai.AI#performNonCombatAI()
	 */
	protected void performNonCombatAI() {
      	//System.out.println("Non-combat.");
		// Get another point if we're not going anywhere
		if (route.hasAnotherPoint() == false) {
			this.Wander90();
		} else {
			this.moveUsingAStar();
		}
	}

	public void Wander90() {
		if (trooper.isWithinAngle(target_angle, Client.TURN_SPEED) == false) {
			trooper.turnTowardsIfEnoughAPs(target_angle);
		} else {
			trooper.turnIfEnoughAPs(target_angle, true); // Align us by the last few degrees
			if (trooper.moveForwardsIfEnoughAPs().moveSuccessful() == false) {
				// Is it a door?
				SMapSquare sq = trooper.getFacingMapSquare();
				if (sq.getType() == SMapSquare.CLOSED_DOOR) {
					if (trooper.getAPs() >= SPlayerObject3D.OPEN_DOOR_COST) {
						Server.map.openDoor(sq);
						trooper.reduceAPs(SPlayerObject3D.OPEN_DOOR_COST, false);
					}
				} else {
					this.target_angle += 180; // turn us round.
					if (this.target_angle > 360) {
						this.target_angle -= 360;
					}
					turn_next_square = true;
				}
			} else {
				// New direction
				if (isInMiddleOfSquare()) {
					if (turn_next_square || Functions.rnd(1, 15) == 1) {
						turn_next_square = false;
						this.getNewAngle();
					}
				}
			}
		}
	}

	private boolean isInMiddleOfSquare() {
		int x = (int)trooper.getX();
		int z = (int)trooper.getZ();
		float x2 = trooper.getX() - x;
		float z2 = trooper.getZ() - z;

		if (x2 > 0.4f && x2 < 0.6f && z2 > 0.4f && z2 < 0.6f) {
			return true;
		}
		return false;
	}

	private void getNewAngle() {
		this.target_angle = Functions.rnd(0, 3) * 90;
	}

}
