/*
 * Created on 19-Sep-2005
 *
 */
package ngrave.ai;

import java.io.IOException;

import ngrave.client.Client;
import ngrave.server.SMapSquare;
import ngrave.server.Server;
import ngrave.server.ServerFunctions;
import ngrave.server.objects.SPlayerObject3D;
import ssmith.lang.Functions;

/**
 * @author stephen smith
 *
 */
public class AlienAI extends AI {

	private static final float EXPLOSION_RAD = 3f;

	  private int target_angle;
	  private boolean turn_next_square = false;

	/**
	 * @param po
	 * @throws IOException
	 */
	public AlienAI(SPlayerObject3D po) {
		super(po);
	}

	  public void doAI() {
	  	super.doAI();
	  	performNonCombatAI(); // Do it anyway as we can't shoot
	  }

	/* (non-Javadoc)
	 * @see ngrave.ai.AI#performNonCombatAI()
	 */
	protected void performNonCombatAI() {
      	//System.out.println("Non-combat.");
	  	if (this.enemy != null) {
	  		// If we're close, explode
		  	if (this.trooper.distanceTo(enemy) <= EXPLOSION_RAD) {
		  		ServerFunctions.explode(this.trooper);
		  		this.trooper.damage(999, 0); // As the exploder doesn't harm itself
		  	}
	  	}
	  	// If we can see the target, go!
  		if (this.route.hasAnotherPoint()) {
  			super.moveUsingAStar();
  		} else {
  		  	if (this.enemy != null) {
				/*Point p = new Point((int)enemy.getX(), (int)enemy.getZ());
				getRoute(p, -1);*/
				calcRoute((int)enemy.getX(), (int)enemy.getZ(), -1);
  		  	} else {
  				this.Wander90();
  		  	}
	  	}

	}

	public void Wander90() {
		if (trooper.isWithinAngle(target_angle, Client.TURN_SPEED) == false) {
			trooper.turnTowardsIfEnoughAPs(target_angle);
		} else {
			trooper.turnIfEnoughAPs(target_angle, true); // Align us by the last few degrees
			if (trooper.moveForwardsIfEnoughAPs().moveSuccessful() == false) {
				// Is it a door?
				SMapSquare sq = trooper.getFacingMapSquare();
				if (sq.getType() == SMapSquare.CLOSED_DOOR) {
					if (trooper.getAPs() >= SPlayerObject3D.OPEN_DOOR_COST) {
						Server.map.openDoor(sq);
						trooper.reduceAPs(SPlayerObject3D.OPEN_DOOR_COST, false);
					}
				} else {
					this.target_angle += 180; // turn us round.
					if (this.target_angle > 360) {
						this.target_angle -= 360;
					}
					turn_next_square = true;
				}
			} else {
				// New direction
				if (isInMiddleOfSquare()) {
					if (turn_next_square || Functions.rnd(1, 15) == 1) {
						turn_next_square = false;
						this.getNewAngle();
					}
				}
			}
		}
	}

	private boolean isInMiddleOfSquare() {
		int x = (int)trooper.getX();
		int z = (int)trooper.getZ();
		float x2 = trooper.getX() - x;
		float z2 = trooper.getZ() - z;

		if (x2 > 0.4f && x2 < 0.6f && z2 > 0.4f && z2 < 0.6f) {
			return true;
		}
		return false;
	}

	private void getNewAngle() {
		this.target_angle = Functions.rnd(0, 3) * 90;
	}
	
}
