package ngrave;

                  /*--.          .-"-.
                 /   o_O        / O o \
                 \_  (__\       \_ v _/
                 //   \\        //   \\
                ((     ))      ((     ))
 €€€€€€€€€€€€€€--""---""--€€€€--""---""--€€€€€€€€€€€€€€€€€€€€€€€€€€
 €                 |||            |||                             €
 €                  |              |                              €
 €                                                                €
 € Programmer:Abdul Bezrati                                       €
 € Program   :Nehe's 9th lesson port to JOGL                     €
 € Comments  :None                                                €
 €    _______                                                     €
 €  /` _____ `\;,    abezrati@hotmail.com                         €
 € (__(^===^)__)';,                                 ___           €
 €   /  :::  \   ,;                               /^   ^\         €
 €  |   :::   | ,;'                              ( Ö   Ö )        €
 €€€'._______.'`€€€€€€€€€€€€€€€€€€€€€€€€€€€ --°oOo--(_)--oOo°--€€*/

import net.java.games.jogl.*;
import java.awt.event.*;
import javax.swing.*;
import java.awt.*;

public class Lesson09 implements KeyListener
{
  initRenderer  renderer;
  GLDrawable    glDrawable;
  Animator      animator;
  GLCanvas      canvas;
  Lesson09      demo;
  JFrame        frame;
  int           num = 50;
  GLU           glu;
  GL            gl;

  // User Defined Variables
  boolean       twinkle,                     // Twinkling Stars
                keys[]  = new boolean[256];  // Array Used For The Keyboard Routine

  class         stars{                       // Create A Structure For Star
                       int r, g, b;          // Stars Color
                       float dist,           // Stars Distance From Center
                             angle;          // Stars Current Angle
                     }

  stars         star[] = new stars[num];     // Need To Keep Track Of 'num' Stars

  float         zoom   = -15.0f,             // Distance Away From Stars
                tilt   =  90.0f,             // Tilt The View
                spin;                        // Spin Stars

  int           screenWidth,
                screenHeight,
                canvasHeight,
                canvasWidth,
                texture[] = new int[1],      // Storage For One textures
                xLocation,
                yLocation,
                loop;                        // General Loop Variable

  public static void main(String []args) {
    new Lesson09();
  }

  Lesson09(){
    int fullScreen = JOptionPane.showConfirmDialog(        null, "Would you like to run in fullscreen mode?",
                                                   "Fullscreen",  JOptionPane.YES_NO_OPTION);
    if(fullScreen!=0)
      JFrame.setDefaultLookAndFeelDecorated(true);

    frame          = new JFrame("NeHe's Animated Blended Textures Tutorial");
    screenWidth    = Toolkit.getDefaultToolkit().getScreenSize().width;
    screenHeight   = Toolkit.getDefaultToolkit().getScreenSize().height;

    switch(fullScreen){
      case 0:
        frame.setUndecorated(true);
      break;
      default:
        canvasWidth  = 640;
        canvasHeight = 480;
        xLocation    = (screenWidth  - canvasWidth )>>1;
        yLocation    = (screenHeight - canvasHeight)>>1;
        frame.setLocation(xLocation,yLocation);
        //frame.setIconImage(new ImageIcon("data/icon.png").getImage());
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    }
    canvas  = GLDrawableFactory.getFactory().createGLCanvas(new GLCapabilities());
    canvas.setSize(new Dimension(canvasWidth,canvasHeight));
    canvas.addGLEventListener((renderer = new initRenderer()));
    canvas.addKeyListener(this);

    frame.addKeyListener(this);
    frame.getContentPane().add(canvas,BorderLayout.CENTER);

    if(fullScreen==0){
      GraphicsEnvironment.getLocalGraphicsEnvironment().
      getDefaultScreenDevice().setFullScreenWindow(frame);
      GraphicsEnvironment.getLocalGraphicsEnvironment().
      getDefaultScreenDevice().setDisplayMode((new DisplayMode(640, 480, 32,
                                               DisplayMode.REFRESH_RATE_UNKNOWN)));
    }

    frame.pack();
    frame.requestFocus();
    frame.setVisible(true);
  }

  private loadImage loadBMP(String filename){

    loadImage  loader = new loadImage();
    loader.generateTextureInfo(filename, false);
    return loader;
  }

  void LoadGLTextures(){                                    // Load Bitmaps And Convert To Textures
    loadImage TextureImage = loadBMP("./data/textures/star.bmp");    // Create Storage Space For The Texture
    gl.glGenTextures(1, texture);                           // Create One Texture

    // Create Linear Filtered Texture
    gl.glBindTexture(GL.GL_TEXTURE_2D, texture[0]);
    gl.glTexParameteri(GL.GL_TEXTURE_2D,GL.GL_TEXTURE_MAG_FILTER,GL.GL_LINEAR);
    gl.glTexParameteri(GL.GL_TEXTURE_2D,GL.GL_TEXTURE_MIN_FILTER,GL.GL_LINEAR);
    gl.glTexImage2D(GL.GL_TEXTURE_2D, 0, 3, TextureImage.width, TextureImage.height, 0, GL.GL_RGB, GL.GL_UNSIGNED_BYTE, TextureImage.data);
  }

  public class initRenderer
               implements GLEventListener
  {
    public void init(GLDrawable drawable){

      gl         = drawable.getGL();
      glu        = drawable.getGLU();
      glDrawable = drawable;

      drawable.setGL( new DebugGL(drawable.getGL()));
      gl.glEnable(GL.GL_TEXTURE_2D);                              // Enable Texture Mapping
      gl.glShadeModel(GL.GL_SMOOTH);                              // Enable Smooth Shading
      gl.glClearColor(0.0f, 0.0f, 0.0f, 0.5f);                    // Black Background
      gl.glClearDepth(1.0f);                                      // Depth Buffer Setup
      gl.glHint(GL.GL_PERSPECTIVE_CORRECTION_HINT,GL.GL_NICEST);  // Really Nice Perspective Calculations
      gl.glBlendFunc(GL.GL_SRC_ALPHA,GL.GL_ONE);                  // Set The Blending Function For Translucency
      gl.glEnable(GL.GL_BLEND);

      for(loop=0; loop<num; loop++){
        star[loop] = new stars();
        star[loop].angle=0.0f;
        star[loop].dist =((float)loop/num)*5.0f;
        star[loop].r = (int)(Math.random()*1000)%256;
        star[loop].g = (int)(Math.random()*1000)%256;
        star[loop].b = (int)(Math.random()*1000)%256;
      }
      LoadGLTextures();
      animator = new Animator(glDrawable);
      animator.start();
    }

    public void display(GLDrawable drawable){
      // Clear Color Buffer, Depth Buffer
      gl.glClear(GL.GL_COLOR_BUFFER_BIT | GL.GL_DEPTH_BUFFER_BIT );
      gl.glBindTexture(GL.GL_TEXTURE_2D, texture[0]);     // Select Our Texture

      for(loop=num-1; loop>=0; loop--){                   // Loop Through All The Stars
        gl.glLoadIdentity();                              // Reset The View Before We Draw Each Star
        gl.glTranslatef(0.0f,0.0f,zoom);                  // Zoom Into The Screen (Using The Value In 'zoom')
        gl.glRotatef(tilt,1.0f,0.0f,0.0f);                // Tilt The View (Using The Value In 'tilt')
        gl.glRotatef(star[loop].angle,0.0f,1.0f,0.0f);    // Rotate To The Current Stars Angle
        gl.glTranslatef(star[loop].dist,0.0f,0.0f);       // Move Forward On The X Plane
        gl.glRotatef(-star[loop].angle,0.0f,1.0f,0.0f);   // Cancel The Current Stars Angle
        gl.glRotatef(-tilt,1.0f,0.0f,0.0f);               // Cancel The Screen Tilt

        if(twinkle){
          gl.glColor4ub((byte)star[(num-loop)-1].r,(byte)star[(num-loop)-1].g,(byte)star[(num-loop)-1].b,(byte)255);
          gl.glBegin(GL.GL_QUADS);
            gl.glTexCoord2f(0.0f, 0.0f); gl.glVertex3f(-1.0f,-1.0f, 0.0f);
            gl.glTexCoord2f(1.0f, 0.0f); gl.glVertex3f( 1.0f,-1.0f, 0.0f);
            gl.glTexCoord2f(1.0f, 1.0f); gl.glVertex3f( 1.0f, 1.0f, 0.0f);
            gl.glTexCoord2f(0.0f, 1.0f); gl.glVertex3f(-1.0f, 1.0f, 0.0f);
          gl.glEnd();
        }

        gl.glRotatef(spin,0.0f,0.0f,1.0f);
        gl.glColor4ub((byte)star[loop].r,(byte)star[loop].g,(byte)star[loop].b,(byte)255);
        gl.glBegin(GL.GL_QUADS);
          gl.glTexCoord2f(0.0f, 0.0f); gl.glVertex3f(-1.0f,-1.0f, 0.0f);
          gl.glTexCoord2f(1.0f, 0.0f); gl.glVertex3f( 1.0f,-1.0f, 0.0f);
          gl.glTexCoord2f(1.0f, 1.0f); gl.glVertex3f( 1.0f, 1.0f, 0.0f);
          gl.glTexCoord2f(0.0f, 1.0f); gl.glVertex3f(-1.0f, 1.0f, 0.0f);
        gl.glEnd();

        spin+=0.01f;
        star[loop].angle+=(float)loop/num;
        star[loop].dist-=0.01f;

        if(star[loop].dist<0.0f){
           star[loop].dist+=5.0f;
           star[loop].r = (int)(Math.random()*1000)%256;
           star[loop].g = (int)(Math.random()*1000)%256;
           star[loop].b = (int)(Math.random()*1000)%256;
        }
      }
      processKeyboard();
    }

    public void reshape(GLDrawable drawable,
                        int xstart,int ystart,
                        int width, int height){

      height = (height == 0) ? 1 : height;

      gl.glViewport(0,0,width,height);
      gl.glMatrixMode(GL.GL_PROJECTION);
      gl.glLoadIdentity();

      glu.gluPerspective(45,(float)width/height,1,1000);
      gl.glMatrixMode(GL.GL_MODELVIEW);
      gl.glLoadIdentity();
    }

    public void displayChanged(GLDrawable drawable,
                               boolean modeChanged,
                               boolean deviceChanged){}
  }

  public void processKeyboard(){
    if(keys[KeyEvent.VK_UP])
      tilt-=0.5f;

    if(keys[KeyEvent.VK_DOWN])
      tilt+=0.5f;

    if(keys[KeyEvent.VK_PAGE_DOWN])
      zoom-=0.2f;

    if(keys[KeyEvent.VK_PAGE_UP])
      zoom+=0.2f;
  }

  public void keyReleased(KeyEvent evt){
    keys[evt.getKeyCode()]=false;
  }

  public void keyPressed (KeyEvent evt){
    keys[evt.getKeyCode()] = true;

    if(keys[KeyEvent.VK_ESCAPE]){
      animator.stop();
      System.exit(0);
    }

    if(keys[KeyEvent.VK_T])
      twinkle=!twinkle;
  }

  public void keyTyped(KeyEvent evt){}
  public class shutDownWindow extends WindowAdapter {
    public void windowClosing(WindowEvent e) {
      animator.stop();
    }
  }
}
